/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.repo;

import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.notebook.NoteParser;
import org.apache.zeppelin.notebook.repo.GitNotebookRepo;
import org.apache.zeppelin.notebook.repo.NotebookRepoWithVersionControl;
import org.apache.zeppelin.user.AuthenticationInfo;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullCommand;
import org.eclipse.jgit.api.PushCommand;
import org.eclipse.jgit.api.RemoteAddCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GitHubNotebookRepo
extends GitNotebookRepo {
    private static final Logger LOGGER = LoggerFactory.getLogger(GitHubNotebookRepo.class);
    private ZeppelinConfiguration zConf;
    private Git git;

    public void init(ZeppelinConfiguration zConf, NoteParser noteParser) throws IOException {
        super.init(zConf, noteParser);
        LOGGER.debug("initializing GitHubNotebookRepo");
        this.git = super.getGit();
        this.zConf = zConf;
        this.configureRemoteStream();
        this.pullFromRemoteStream();
        this.pushToRemoteSteam();
    }

    public NotebookRepoWithVersionControl.Revision checkpoint(String noteId, String notePath, String commitMessage, AuthenticationInfo subject) throws IOException {
        NotebookRepoWithVersionControl.Revision revision = super.checkpoint(noteId, notePath, commitMessage, subject);
        this.updateRemoteStream();
        return revision;
    }

    private void configureRemoteStream() {
        try {
            LOGGER.debug("Setting up remote stream");
            RemoteAddCommand remoteAddCommand = this.git.remoteAdd();
            remoteAddCommand.setName(this.zConf.getZeppelinNotebookGitRemoteOrigin());
            remoteAddCommand.setUri(new URIish(this.zConf.getZeppelinNotebookGitURL()));
            remoteAddCommand.call();
        }
        catch (GitAPIException e) {
            LOGGER.error("Error configuring GitHub", (Throwable)e);
        }
        catch (URISyntaxException e) {
            LOGGER.error("Error in GitHub URL provided", (Throwable)e);
        }
    }

    private void updateRemoteStream() {
        LOGGER.debug("Updating remote stream");
        this.pullFromRemoteStream();
        this.pushToRemoteSteam();
    }

    private void pullFromRemoteStream() {
        try {
            LOGGER.debug("Pulling latest changes from remote stream");
            PullCommand pullCommand = this.git.pull();
            pullCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.zConf.getZeppelinNotebookGitUsername(), this.zConf.getZeppelinNotebookGitAccessToken()));
            pullCommand.call();
        }
        catch (GitAPIException e) {
            LOGGER.error("Error when pulling latest changes from remote repository", (Throwable)e);
        }
    }

    private void pushToRemoteSteam() {
        try {
            LOGGER.debug("Pushing latest changes to remote stream");
            PushCommand pushCommand = this.git.push();
            pushCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(this.zConf.getZeppelinNotebookGitUsername(), this.zConf.getZeppelinNotebookGitAccessToken()));
            pushCommand.call();
        }
        catch (GitAPIException e) {
            LOGGER.error("Error when pushing latest changes to remote repository", (Throwable)e);
        }
    }
}

