/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jupyter.io.grpc.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.zeppelin.jupyter.io.grpc.HandlerRegistry;
import org.apache.zeppelin.jupyter.io.grpc.ServerMethodDefinition;
import org.apache.zeppelin.jupyter.io.grpc.ServerServiceDefinition;

final class InternalHandlerRegistry
extends HandlerRegistry {
    private final List<ServerServiceDefinition> services;
    private final Map<String, ServerMethodDefinition<?, ?>> methods;

    private InternalHandlerRegistry(List<ServerServiceDefinition> services, Map<String, ServerMethodDefinition<?, ?>> methods) {
        this.services = services;
        this.methods = methods;
    }

    @Override
    public List<ServerServiceDefinition> getServices() {
        return this.services;
    }

    @Override
    @Nullable
    public ServerMethodDefinition<?, ?> lookupMethod(String methodName, @Nullable String authority) {
        return this.methods.get(methodName);
    }

    static final class Builder {
        private final HashMap<String, ServerServiceDefinition> services = new LinkedHashMap<String, ServerServiceDefinition>();

        Builder() {
        }

        Builder addService(ServerServiceDefinition service) {
            this.services.put(service.getServiceDescriptor().getName(), service);
            return this;
        }

        InternalHandlerRegistry build() {
            HashMap map = new HashMap();
            for (ServerServiceDefinition service : this.services.values()) {
                for (ServerMethodDefinition<?, ?> method : service.getMethods()) {
                    map.put(method.getMethodDescriptor().getFullMethodName(), method);
                }
            }
            return new InternalHandlerRegistry(Collections.unmodifiableList(new ArrayList<ServerServiceDefinition>(this.services.values())), Collections.unmodifiableMap(map));
        }
    }
}

