/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.helium;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.zeppelin.common.JsonSerializable;
import org.apache.zeppelin.helium.HeliumPackage;
import org.apache.zeppelin.helium.HeliumRegistry;
import org.apache.zeppelin.helium.HeliumRegistrySerializer;

public class HeliumConf
implements JsonSerializable {
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(HeliumRegistry.class, (Object)new HeliumRegistrySerializer()).create();
    private Map<String, String> enabled = Collections.synchronizedMap(new HashMap());
    private Map<String, Map<String, Object>> packageConfig = Collections.synchronizedMap(new HashMap());
    private List<String> bundleDisplayOrder = Collections.synchronizedList(new LinkedList());

    public Map<String, String> getEnabledPackages() {
        return new HashMap<String, String>(this.enabled);
    }

    public void enablePackage(String name, String artifact) {
        this.enabled.put(name, artifact);
    }

    public void updatePackageConfig(String artifact, Map<String, Object> newConfig) {
        if (!this.packageConfig.containsKey(artifact)) {
            this.packageConfig.put(artifact, Collections.synchronizedMap(new HashMap()));
        }
        this.packageConfig.put(artifact, newConfig);
    }

    public Map<String, Map<String, Object>> getAllPackageConfigs() {
        return this.packageConfig;
    }

    public Map<String, Object> getPackagePersistedConfig(String artifact) {
        if (!this.packageConfig.containsKey(artifact)) {
            this.packageConfig.put(artifact, Collections.synchronizedMap(new HashMap()));
        }
        return this.packageConfig.get(artifact);
    }

    public void disablePackage(HeliumPackage pkg) {
        this.disablePackage(pkg.getName());
    }

    public void disablePackage(String name) {
        this.enabled.remove(name);
    }

    public List<String> getBundleDisplayOrder() {
        if (this.bundleDisplayOrder == null) {
            return new LinkedList<String>();
        }
        return this.bundleDisplayOrder;
    }

    public void setBundleDisplayOrder(List<String> orderedPackageList) {
        this.bundleDisplayOrder = Collections.synchronizedList(orderedPackageList);
    }

    public String toJson() {
        return gson.toJson((Object)this);
    }

    public static HeliumConf fromJson(String json) {
        return (HeliumConf)gson.fromJson(json, HeliumConf.class);
    }
}

