/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.apache.zeppelin.user.UserCredentials;
import org.apache.zeppelin.user.UsernamePassword;

class CredentialInjector {
    private Set<String> passwords = new HashSet<String>();
    private final UserCredentials creds;
    private static final Pattern userpattern = Pattern.compile("\\{([^\\}]+)\\.user\\}");
    private static final Pattern passwordpattern = Pattern.compile("\\{([^\\}]+)\\.password\\}");

    public CredentialInjector(UserCredentials creds) {
        this.creds = creds;
    }

    public String replaceCredentials(String code) {
        String quotedValue;
        String value;
        UsernamePassword usernamePassword;
        String key;
        if (code == null) {
            return null;
        }
        String replaced = code;
        Matcher matcher = userpattern.matcher(replaced);
        while (matcher.find()) {
            key = matcher.group(1);
            usernamePassword = this.creds.getUsernamePassword(key);
            if (usernamePassword == null) continue;
            value = usernamePassword.getUsername();
            quotedValue = Matcher.quoteReplacement(value);
            replaced = matcher.replaceFirst(quotedValue);
            matcher = userpattern.matcher(replaced);
        }
        matcher = passwordpattern.matcher(replaced);
        while (matcher.find()) {
            key = matcher.group(1);
            usernamePassword = this.creds.getUsernamePassword(key);
            if (usernamePassword == null) continue;
            this.passwords.add(usernamePassword.getPassword());
            value = usernamePassword.getPassword();
            quotedValue = Matcher.quoteReplacement(value);
            replaced = matcher.replaceFirst(quotedValue);
            matcher = passwordpattern.matcher(replaced);
        }
        return replaced;
    }

    public InterpreterResult hidePasswords(InterpreterResult ret) {
        if (ret == null) {
            return null;
        }
        return new InterpreterResult(ret.code(), this.replacePasswords(ret.message()));
    }

    private List<InterpreterResultMessage> replacePasswords(List<InterpreterResultMessage> original) {
        ArrayList<InterpreterResultMessage> replaced = new ArrayList<InterpreterResultMessage>();
        block3: for (InterpreterResultMessage msg : original) {
            switch (msg.getType()) {
                case HTML: 
                case TEXT: 
                case TABLE: {
                    String replacedMessages = this.replacePasswords(msg.getData());
                    replaced.add(new InterpreterResultMessage(msg.getType(), replacedMessages));
                    continue block3;
                }
            }
            replaced.add(msg);
        }
        return replaced;
    }

    private String replacePasswords(String str) {
        String result = str;
        for (String password : this.passwords) {
            result = result.replace(password, "###");
        }
        return result;
    }
}

