/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.notebook.scheduler;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.notebook.Notebook;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricCronJobListener
implements JobListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricCronJobListener.class);
    private final Map<JobExecutionContext, Timer.Sample> cronJobTimerSamples = new HashMap<JobExecutionContext, Timer.Sample>();

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String noteId = jobDataMap.getString("noteId");
        LOGGER.info("Start cron job of note: {}", (Object)noteId);
        this.cronJobTimerSamples.put(context, Timer.start((MeterRegistry)Metrics.globalRegistry));
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        Timer.Sample sample;
        JobDataMap jobDataMap = context.getJobDetail().getJobDataMap();
        String noteId = jobDataMap.getString("noteId");
        Notebook notebook = (Notebook)jobDataMap.get((Object)"notebook");
        String noteName = "unknown";
        try {
            noteName = notebook.processNote(noteId, note -> {
                if (note == null) {
                    LOGGER.warn("Failed to get note: {}", (Object)noteId);
                    return "unknown";
                }
                return note.getName();
            });
            sample = this.cronJobTimerSamples.remove(context);
        }
        catch (IOException e) {
            Timer.Sample sample2;
            try {
                LOGGER.error("Failed to get note: {}", (Object)noteId, (Object)e);
                sample2 = this.cronJobTimerSamples.remove(context);
            }
            catch (Throwable throwable) {
                Timer.Sample sample3 = this.cronJobTimerSamples.remove(context);
                String result = StringUtils.defaultString((String)context.getResult().toString(), (String)"unknown");
                LOGGER.info("cron job of noteId {} executed with result {}", (Object)noteId, (Object)result);
                if (sample3 != null) {
                    Tag noteIdTag = Tag.of((String)"nodeid", (String)noteId);
                    Tag nameTag = Tag.of((String)"name", (String)noteName);
                    Tag statusTag = Tag.of((String)"result", (String)result);
                    sample3.stop(Metrics.timer((String)"cronjob", (Iterable)Tags.of((Tag[])new Tag[]{noteIdTag, nameTag, statusTag})));
                } else {
                    LOGGER.warn("No Timer.Sample for NoteId {} found", (Object)noteId);
                }
                throw throwable;
            }
            String result = StringUtils.defaultString((String)context.getResult().toString(), (String)"unknown");
            LOGGER.info("cron job of noteId {} executed with result {}", (Object)noteId, (Object)result);
            if (sample2 != null) {
                Tag noteIdTag = Tag.of((String)"nodeid", (String)noteId);
                Tag nameTag = Tag.of((String)"name", (String)noteName);
                Tag statusTag = Tag.of((String)"result", (String)result);
                sample2.stop(Metrics.timer((String)"cronjob", (Iterable)Tags.of((Tag[])new Tag[]{noteIdTag, nameTag, statusTag})));
            } else {
                LOGGER.warn("No Timer.Sample for NoteId {} found", (Object)noteId);
            }
        }
        String result = StringUtils.defaultString((String)context.getResult().toString(), (String)"unknown");
        LOGGER.info("cron job of noteId {} executed with result {}", (Object)noteId, (Object)result);
        if (sample != null) {
            Tag noteIdTag = Tag.of((String)"nodeid", (String)noteId);
            Tag nameTag = Tag.of((String)"name", (String)noteName);
            Tag statusTag = Tag.of((String)"result", (String)result);
            sample.stop(Metrics.timer((String)"cronjob", (Iterable)Tags.of((Tag[])new Tag[]{noteIdTag, nameTag, statusTag})));
        } else {
            LOGGER.warn("No Timer.Sample for NoteId {} found", (Object)noteId);
        }
    }
}

