/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink;

import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.StringUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.core.execution.JobClient;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobManager.class);
    public static final String LATEST_CHECKPOINT_PATH = "latest_checkpoint_path";
    public static final String SAVEPOINT_PATH = "savepoint_path";
    public static final String RESUME_FROM_SAVEPOINT = "resumeFromSavepoint";
    public static final String RESUME_FROM_CHECKPOINT = "resumeFromLatestCheckpoint";
    public static final String SAVEPOINT_DIR = "savepointDir";
    private Map<String, JobClient> jobs = new HashMap<String, JobClient>();
    private ConcurrentHashMap<JobID, FlinkJobProgressPoller> jobProgressPollerMap = new ConcurrentHashMap();
    private String flinkWebUrl;
    private String displayedFlinkWebUrl;
    private Properties properties;

    public JobManager(String flinkWebUrl, String displayedFlinkWebUrl, Properties properties) {
        this.flinkWebUrl = flinkWebUrl;
        this.displayedFlinkWebUrl = displayedFlinkWebUrl;
        this.properties = properties;
        LOGGER.info("Creating JobManager at flinkWebUrl: {}, displayedFlinkWebUrl: {}", (Object)flinkWebUrl, (Object)displayedFlinkWebUrl);
    }

    public void addJob(InterpreterContext context, JobClient jobClient) {
        String paragraphId = context.getParagraphId();
        JobClient previousJobClient = this.jobs.put(paragraphId, jobClient);
        if (previousJobClient != null) {
            LOGGER.warn("There's another Job {} that is associated with paragraph {}", (Object)jobClient.getJobID(), (Object)paragraphId);
            return;
        }
        long checkInterval = Long.parseLong(this.properties.getProperty("zeppelin.flink.job.check_interval", "1000"));
        if (checkInterval < 0L) {
            LOGGER.warn("The value of checkInterval must be positive {}", (Object)checkInterval);
            return;
        }
        FlinkJobProgressPoller thread = new FlinkJobProgressPoller(this.flinkWebUrl, jobClient.getJobID(), context, checkInterval);
        thread.setName("JobProgressPoller-Thread-" + paragraphId);
        thread.start();
        this.jobProgressPollerMap.put(jobClient.getJobID(), thread);
    }

    public void removeJob(String paragraphId) {
        LOGGER.info("Remove job in paragraph: {}", (Object)paragraphId);
        JobClient jobClient = this.jobs.remove(paragraphId);
        if (jobClient == null) {
            LOGGER.warn("Unable to remove job, because no job is associated with paragraph: {}", (Object)paragraphId);
            return;
        }
        FlinkJobProgressPoller jobProgressPoller = this.jobProgressPollerMap.remove(jobClient.getJobID());
        if (jobProgressPoller == null) {
            LOGGER.warn("Unable to remove poller, because no poller is associated with paragraph: {}", (Object)paragraphId);
            return;
        }
        jobProgressPoller.cancel();
        jobProgressPoller.interrupt();
    }

    public void sendFlinkJobUrl(InterpreterContext context) {
        JobClient jobClient = this.jobs.get(context.getParagraphId());
        if (jobClient != null) {
            String jobUrl = this.displayedFlinkWebUrl + "#/job/" + jobClient.getJobID();
            HashMap<String, Object> infos = new HashMap<String, Object>();
            infos.put("jobUrl", jobUrl);
            infos.put("label", "FLINK JOB");
            infos.put("tooltip", "View in Flink web UI");
            infos.put("noteId", context.getNoteId());
            infos.put("paraId", context.getParagraphId());
            context.getIntpEventClient().onParaInfosReceived(infos);
        } else {
            LOGGER.warn("No job is associated with paragraph: {}", (Object)context.getParagraphId());
        }
    }

    public int getJobProgress(String paragraphId) {
        JobClient jobClient = this.jobs.get(paragraphId);
        if (jobClient == null) {
            LOGGER.warn("Unable to get job progress for paragraph: {}, because no job is associated with this paragraph", (Object)paragraphId);
            return 0;
        }
        FlinkJobProgressPoller jobProgressPoller = this.jobProgressPollerMap.get(jobClient.getJobID());
        if (jobProgressPoller == null) {
            LOGGER.warn("Unable to get job progress for paragraph: {}, because no job progress is associated with this jobId: {}", (Object)paragraphId, (Object)jobClient.getJobID());
            return 0;
        }
        return jobProgressPoller.getProgress();
    }

    public void cancelJob(InterpreterContext context) throws InterpreterException {
        LOGGER.info("Canceling job associated of paragraph: {}", (Object)context.getParagraphId());
        JobClient jobClient = this.jobs.get(context.getParagraphId());
        if (jobClient == null) {
            LOGGER.warn("Unable to remove Job from paragraph {} as no job associated to this paragraph", (Object)context.getParagraphId());
            return;
        }
        boolean cancelled = false;
        try {
            String savePointDir = (String)context.getLocalProperties().get(SAVEPOINT_DIR);
            if (StringUtils.isBlank(savePointDir)) {
                LOGGER.info("Trying to cancel job of paragraph {}", (Object)context.getParagraphId());
                jobClient.cancel();
            } else {
                LOGGER.info("Trying to stop job of paragraph {} with save point dir: {}", (Object)context.getParagraphId(), (Object)savePointDir);
                try {
                    String savePointPath = (String)jobClient.stopWithSavepoint(true, savePointDir).get();
                    HashMap<String, String> config = new HashMap<String, String>();
                    config.put(SAVEPOINT_PATH, savePointPath);
                    context.getIntpEventClient().updateParagraphConfig(context.getNoteId(), context.getParagraphId(), config);
                    LOGGER.info("Job {} of paragraph {} is stopped with save point path: {}", jobClient.getJobID(), context.getParagraphId(), savePointPath);
                }
                catch (Exception e) {
                    LOGGER.warn("Fail to cancel job of paragraph {} with savepoint, try to cancel it without savepoint", (Object)context.getParagraphId(), (Object)e);
                    jobClient.cancel();
                }
            }
            cancelled = true;
        }
        catch (Exception e) {
            String errorMessage = String.format("Fail to cancel job %s that is associated with paragraph %s", jobClient.getJobID(), context.getParagraphId());
            LOGGER.warn(errorMessage, e);
            throw new InterpreterException(errorMessage, (Throwable)e);
        }
        finally {
            if (cancelled) {
                LOGGER.info("Cancelling is successful, remove the associated FlinkJobProgressPoller of paragraph: {}", (Object)context.getParagraphId());
                FlinkJobProgressPoller jobProgressPoller = this.jobProgressPollerMap.remove(jobClient.getJobID());
                if (jobProgressPoller != null) {
                    jobProgressPoller.cancel();
                    jobProgressPoller.interrupt();
                }
                this.jobs.remove(context.getParagraphId());
            }
        }
    }

    public void shutdown() {
        for (FlinkJobProgressPoller jobProgressPoller : this.jobProgressPollerMap.values()) {
            jobProgressPoller.cancel();
        }
    }

    static String toRichTimeDuration(long duration) {
        long days = TimeUnit.SECONDS.toDays(duration);
        long hours = TimeUnit.SECONDS.toHours(duration -= TimeUnit.DAYS.toSeconds(days));
        long minutes = TimeUnit.SECONDS.toMinutes(duration -= TimeUnit.HOURS.toSeconds(hours));
        long seconds = TimeUnit.SECONDS.toSeconds(duration -= TimeUnit.MINUTES.toSeconds(minutes));
        StringBuilder builder = new StringBuilder();
        if (days != 0L) {
            builder.append(days + " days ");
        }
        if (days != 0L || hours != 0L) {
            builder.append(hours + " hours ");
        }
        if (days != 0L || hours != 0L || minutes != 0L) {
            builder.append(minutes + " minutes ");
        }
        builder.append(seconds + " seconds");
        return builder.toString();
    }

    class FlinkJobProgressPoller
    extends Thread {
        private String flinkWebUrl;
        private JobID jobId;
        private InterpreterContext context;
        private boolean isStreamingInsertInto;
        private int progress;
        private AtomicBoolean running = new AtomicBoolean(true);
        private boolean isFirstPoll = true;
        private long checkInterval;
        private String latestCheckpointPath;

        FlinkJobProgressPoller(String flinkWebUrl, JobID jobId, InterpreterContext context, long checkInterval) {
            this.flinkWebUrl = flinkWebUrl;
            this.jobId = jobId;
            this.context = context;
            this.isStreamingInsertInto = context.getLocalProperties().containsKey("flink.streaming.insert_into");
            this.checkInterval = checkInterval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!Thread.currentThread().isInterrupted() && this.running.get()) {
                JsonNode rootNode = null;
                try {
                    JSONObject completedObject;
                    JSONObject latestObject;
                    String jobState;
                    AtomicBoolean atomicBoolean = this.running;
                    synchronized (atomicBoolean) {
                        this.running.wait(this.checkInterval);
                    }
                    rootNode = Unirest.get(this.flinkWebUrl + "/jobs/" + this.jobId.toString()).asJson().getBody();
                    JSONArray vertices = rootNode.getObject().getJSONArray("vertices");
                    int totalTasks = 0;
                    int finishedTasks = 0;
                    for (int i = 0; i < vertices.length(); ++i) {
                        JSONObject vertex = vertices.getJSONObject(i);
                        totalTasks += vertex.getInt("parallelism");
                        finishedTasks += vertex.getJSONObject("tasks").getInt("FINISHED");
                    }
                    LOGGER.debug("Total tasks:{}", (Object)totalTasks);
                    LOGGER.debug("Finished tasks:{}", (Object)finishedTasks);
                    if (finishedTasks != 0) {
                        this.progress = finishedTasks * 100 / totalTasks;
                        LOGGER.debug("Progress: {}", (Object)this.progress);
                    }
                    if ((jobState = rootNode.getObject().getString("state")).equalsIgnoreCase("finished")) break;
                    long duration = rootNode.getObject().getLong("duration") / 1000L;
                    if (this.isStreamingInsertInto) {
                        if (this.isFirstPoll) {
                            StringBuilder builder = new StringBuilder("%angular ");
                            builder.append("<h1>Duration: {{duration}} </h1>");
                            builder.append("\n%text ");
                            this.context.out.clear(false);
                            this.context.out.write(builder.toString());
                            this.context.out.flush();
                            this.isFirstPoll = false;
                        }
                        this.context.getAngularObjectRegistry().add("duration", (Object)JobManager.toRichTimeDuration(duration), this.context.getNoteId(), this.context.getParagraphId());
                    }
                    if (!(rootNode = Unirest.get(this.flinkWebUrl + "/jobs/" + this.jobId.toString() + "/checkpoints").asJson().getBody()).getObject().has("latest") || !(latestObject = rootNode.getObject().getJSONObject("latest")).has("completed") || !(latestObject.get("completed") instanceof JSONObject) || !(completedObject = latestObject.getJSONObject("completed")).has("external_path")) continue;
                    String checkpointPath = completedObject.getString("external_path");
                    LOGGER.debug("Latest checkpoint path: {}", (Object)checkpointPath);
                    if (StringUtils.isBlank(checkpointPath) || checkpointPath.equals(this.latestCheckpointPath)) continue;
                    HashMap<String, String> config = new HashMap<String, String>();
                    config.put(JobManager.LATEST_CHECKPOINT_PATH, checkpointPath);
                    LOGGER.info("Update latest checkpoint path: {}", (Object)checkpointPath);
                    this.context.getIntpEventClient().updateParagraphConfig(this.context.getNoteId(), this.context.getParagraphId(), config);
                    this.latestCheckpointPath = checkpointPath;
                }
                catch (Exception e) {
                    LOGGER.error("Fail to poll flink job progress via rest api", e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            this.running.set(false);
            AtomicBoolean atomicBoolean = this.running;
            synchronized (atomicBoolean) {
                this.running.notify();
            }
        }

        public int getProgress() {
            return this.progress;
        }
    }
}

