/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.flink.sql;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.RowTypeInfo;
import org.apache.flink.streaming.api.scala.StreamExecutionEnvironment;
import org.apache.flink.streaming.experimental.SocketStreamIterator;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.sinks.RetractStreamTableSink;
import org.apache.flink.types.Row;
import org.apache.zeppelin.flink.FlinkShims;
import org.apache.zeppelin.flink.JobManager;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.apache.zeppelin.tabledata.TableDataUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractStreamSqlJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractStreamSqlJob.class);
    private static AtomicInteger SQL_INDEX = new AtomicInteger(0);
    protected StreamExecutionEnvironment senv;
    protected TableEnvironment stenv;
    private Table table;
    protected JobManager jobManager;
    protected InterpreterContext context;
    protected TableSchema schema;
    protected SocketStreamIterator<Tuple2<Boolean, Row>> iterator;
    protected Object resultLock = new Object();
    protected volatile boolean enableToRefresh = true;
    protected int defaultParallelism;
    protected FlinkShims flinkShims;
    protected ScheduledExecutorService refreshScheduler = Executors.newScheduledThreadPool(1);

    public AbstractStreamSqlJob(StreamExecutionEnvironment senv, TableEnvironment stenv, JobManager jobManager, InterpreterContext context, int defaultParallelism, FlinkShims flinkShims) {
        this.senv = senv;
        this.stenv = stenv;
        this.jobManager = jobManager;
        this.context = context;
        this.defaultParallelism = defaultParallelism;
        this.flinkShims = flinkShims;
    }

    private static TableSchema removeTimeAttributes(FlinkShims flinkShims, TableSchema schema) {
        TableSchema.Builder builder = TableSchema.builder();
        for (int i = 0; i < schema.getFieldCount(); ++i) {
            TypeInformation type = schema.getFieldTypes()[i];
            TypeInformation convertedType = flinkShims.isTimeIndicatorType(type) ? Types.SQL_TIMESTAMP : type;
            builder.field(schema.getFieldNames()[i], convertedType);
        }
        return builder.build();
    }

    protected abstract String getType();

    public String run(String st) throws IOException {
        this.table = this.stenv.sqlQuery(st);
        String tableName = "UnnamedTable__" + SQL_INDEX.getAndIncrement();
        return this.run(this.table, tableName);
    }

    public String run(Table table, String tableName) throws IOException {
        try {
            this.table = table;
            int parallelism = Integer.parseInt((String)((Object)this.context.getLocalProperties().getOrDefault("parallelism", "" + this.defaultParallelism)));
            this.schema = AbstractStreamSqlJob.removeTimeAttributes(this.flinkShims, table.getSchema());
            this.checkTableSchema(this.schema);
            LOGGER.info("ResultTable Schema: {}", (Object)this.schema);
            RowTypeInfo outputType = new RowTypeInfo(this.schema.getFieldTypes(), this.schema.getFieldNames());
            TypeInformation socketType = Types.TUPLE((TypeInformation[])new TypeInformation[]{Types.BOOLEAN, outputType});
            TypeSerializer serializer = socketType.createSerializer(this.senv.getConfig());
            this.iterator = new SocketStreamIterator(0, InetAddress.getByName(RemoteInterpreterUtils.findAvailableHostAddress()), serializer);
            LOGGER.debug("Collecting data at address: {}:{}", (Object)this.iterator.getBindAddress(), (Object)this.iterator.getPort());
            RetractStreamTableSink collectTableSink = (RetractStreamTableSink)this.flinkShims.getCollectStreamTableSink(this.iterator.getBindAddress(), this.iterator.getPort(), serializer);
            collectTableSink = (RetractStreamTableSink)collectTableSink.configure(outputType.getFieldNames(), outputType.getFieldTypes());
            this.flinkShims.registerTableSink(this.stenv, tableName, collectTableSink);
            long delay = 1000L;
            long period = Long.parseLong(this.context.getLocalProperties().getOrDefault("refreshInterval", "3000"));
            this.refreshScheduler.scheduleAtFixedRate(new RefreshTask(this.context), delay, period, TimeUnit.MILLISECONDS);
            ResultRetrievalThread retrievalThread = new ResultRetrievalThread(this.refreshScheduler);
            retrievalThread.start();
            LOGGER.info("Run job: {}, parallelism: {}", (Object)tableName, (Object)parallelism);
            String jobName = this.context.getStringLocalProperty("jobName", tableName);
            table.executeInsert(tableName).await();
            LOGGER.info("Flink Job is finished, jobName: {}", (Object)jobName);
            LOGGER.info("Waiting for retrieve thread to be done");
            retrievalThread.join();
            this.refresh(this.context);
            String finalResult = this.buildResult();
            LOGGER.info("Final Result: {}", (Object)finalResult);
            String string = finalResult;
            return string;
        }
        catch (Exception e) {
            LOGGER.error("Fail to run stream sql job", e);
            throw new IOException("Fail to run stream sql job", e);
        }
        finally {
            this.refreshScheduler.shutdownNow();
        }
    }

    protected void checkTableSchema(TableSchema schema) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRecord(Tuple2<Boolean, Row> change) {
        Object object = this.resultLock;
        synchronized (object) {
            if (((Boolean)change.f0).booleanValue()) {
                this.processInsert((Row)change.f1);
            } else {
                this.processDelete((Row)change.f1);
            }
        }
    }

    protected abstract void processInsert(Row var1);

    protected abstract void processDelete(Row var1);

    protected abstract String buildResult();

    protected String tableToString(List<Row> rows) {
        StringBuilder builder = new StringBuilder();
        for (Row row : rows) {
            String[] fields = this.flinkShims.rowToString(row, this.table, this.stenv.getConfig());
            String rowString = Arrays.stream(fields).map(TableDataUtils::normalizeColumn).collect(Collectors.joining("\t"));
            builder.append(rowString);
            builder.append("\n");
        }
        return builder.toString();
    }

    protected abstract void refresh(InterpreterContext var1) throws Exception;

    private class RefreshTask
    implements Runnable {
        private InterpreterContext context;

        RefreshTask(InterpreterContext context) {
            this.context = context;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Object object = AbstractStreamSqlJob.this.resultLock;
                synchronized (object) {
                    if (!AbstractStreamSqlJob.this.enableToRefresh) {
                        AbstractStreamSqlJob.this.resultLock.wait();
                    }
                    LOGGER.debug("Refresh result of paragraph: {}", (Object)this.context.getParagraphId());
                    AbstractStreamSqlJob.this.refresh(this.context);
                }
            }
            catch (Exception e) {
                LOGGER.error("Fail to refresh task", e);
            }
        }
    }

    private class ResultRetrievalThread
    extends Thread {
        private ScheduledExecutorService refreshExecutorService;
        volatile boolean isRunning = true;

        ResultRetrievalThread(ScheduledExecutorService refreshExecutorService) {
            this.refreshExecutorService = refreshExecutorService;
        }

        @Override
        public void run() {
            try {
                while (this.isRunning && AbstractStreamSqlJob.this.iterator.hasNext()) {
                    Tuple2 change = (Tuple2)AbstractStreamSqlJob.this.iterator.next();
                    AbstractStreamSqlJob.this.processRecord((Tuple2<Boolean, Row>)change);
                }
            }
            catch (Throwable e) {
                LOGGER.error("Fail to process record", e);
            }
            this.isRunning = false;
            LOGGER.info("ResultRetrieval Thread is done, isRunning={}, hasNext={}", (Object)this.isRunning, (Object)AbstractStreamSqlJob.this.iterator.hasNext());
            LOGGER.info("Final Result: {}", (Object)AbstractStreamSqlJob.this.buildResult());
            this.refreshExecutorService.shutdownNow();
        }

        public void cancel() {
            this.isRunning = false;
        }
    }
}

