/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.jupyter.io.grpc.internal;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.zeppelin.jupyter.com.google.common.base.MoreObjects;
import org.apache.zeppelin.jupyter.com.google.common.base.Preconditions;
import org.apache.zeppelin.jupyter.com.google.errorprone.annotations.DoNotCall;
import org.apache.zeppelin.jupyter.io.grpc.BinaryLog;
import org.apache.zeppelin.jupyter.io.grpc.ClientInterceptor;
import org.apache.zeppelin.jupyter.io.grpc.CompressorRegistry;
import org.apache.zeppelin.jupyter.io.grpc.DecompressorRegistry;
import org.apache.zeppelin.jupyter.io.grpc.ManagedChannel;
import org.apache.zeppelin.jupyter.io.grpc.ManagedChannelBuilder;
import org.apache.zeppelin.jupyter.io.grpc.NameResolver;
import org.apache.zeppelin.jupyter.io.grpc.ProxyDetector;

public abstract class AbstractManagedChannelImplBuilder<T extends ManagedChannelBuilder<T>>
extends ManagedChannelBuilder<T> {
    protected int maxInboundMessageSize = 0x400000;

    protected AbstractManagedChannelImplBuilder() {
    }

    @DoNotCall(value="Unsupported")
    public static ManagedChannelBuilder<?> forAddress(String name, int port) {
        throw new UnsupportedOperationException("Subclass failed to hide static factory");
    }

    @DoNotCall(value="Unsupported")
    public static ManagedChannelBuilder<?> forTarget(String target) {
        throw new UnsupportedOperationException("Subclass failed to hide static factory");
    }

    protected abstract ManagedChannelBuilder<?> delegate();

    @Override
    public T directExecutor() {
        this.delegate().directExecutor();
        return this.thisT();
    }

    @Override
    public T executor(Executor executor) {
        this.delegate().executor(executor);
        return this.thisT();
    }

    @Override
    public T offloadExecutor(Executor executor) {
        this.delegate().offloadExecutor(executor);
        return this.thisT();
    }

    @Override
    public T intercept(List<ClientInterceptor> interceptors) {
        this.delegate().intercept(interceptors);
        return this.thisT();
    }

    @Override
    public T intercept(ClientInterceptor ... interceptors) {
        this.delegate().intercept(interceptors);
        return this.thisT();
    }

    @Override
    public T userAgent(String userAgent) {
        this.delegate().userAgent(userAgent);
        return this.thisT();
    }

    @Override
    public T overrideAuthority(String authority) {
        this.delegate().overrideAuthority(authority);
        return this.thisT();
    }

    @Override
    public T usePlaintext() {
        this.delegate().usePlaintext();
        return this.thisT();
    }

    @Override
    public T useTransportSecurity() {
        this.delegate().useTransportSecurity();
        return this.thisT();
    }

    @Override
    @Deprecated
    public T nameResolverFactory(NameResolver.Factory resolverFactory) {
        this.delegate().nameResolverFactory(resolverFactory);
        return this.thisT();
    }

    @Override
    public T defaultLoadBalancingPolicy(String policy) {
        this.delegate().defaultLoadBalancingPolicy(policy);
        return this.thisT();
    }

    @Override
    public T enableFullStreamDecompression() {
        this.delegate().enableFullStreamDecompression();
        return this.thisT();
    }

    @Override
    public T decompressorRegistry(DecompressorRegistry registry) {
        this.delegate().decompressorRegistry(registry);
        return this.thisT();
    }

    @Override
    public T compressorRegistry(CompressorRegistry registry) {
        this.delegate().compressorRegistry(registry);
        return this.thisT();
    }

    @Override
    public T idleTimeout(long value, TimeUnit unit) {
        this.delegate().idleTimeout(value, unit);
        return this.thisT();
    }

    @Override
    public T maxInboundMessageSize(int max) {
        Preconditions.checkArgument(max >= 0, "negative max");
        this.maxInboundMessageSize = max;
        return this.thisT();
    }

    @Override
    public T maxInboundMetadataSize(int max) {
        this.delegate().maxInboundMetadataSize(max);
        return this.thisT();
    }

    @Override
    public T keepAliveTime(long keepAliveTime, TimeUnit timeUnit) {
        this.delegate().keepAliveTime(keepAliveTime, timeUnit);
        return this.thisT();
    }

    @Override
    public T keepAliveTimeout(long keepAliveTimeout, TimeUnit timeUnit) {
        this.delegate().keepAliveTimeout(keepAliveTimeout, timeUnit);
        return this.thisT();
    }

    @Override
    public T keepAliveWithoutCalls(boolean enable) {
        this.delegate().keepAliveWithoutCalls(enable);
        return this.thisT();
    }

    @Override
    public T maxRetryAttempts(int maxRetryAttempts) {
        this.delegate().maxRetryAttempts(maxRetryAttempts);
        return this.thisT();
    }

    @Override
    public T maxHedgedAttempts(int maxHedgedAttempts) {
        this.delegate().maxHedgedAttempts(maxHedgedAttempts);
        return this.thisT();
    }

    @Override
    public T retryBufferSize(long bytes) {
        this.delegate().retryBufferSize(bytes);
        return this.thisT();
    }

    @Override
    public T perRpcBufferLimit(long bytes) {
        this.delegate().perRpcBufferLimit(bytes);
        return this.thisT();
    }

    @Override
    public T disableRetry() {
        this.delegate().disableRetry();
        return this.thisT();
    }

    @Override
    public T enableRetry() {
        this.delegate().enableRetry();
        return this.thisT();
    }

    @Override
    public T setBinaryLog(BinaryLog binaryLog) {
        this.delegate().setBinaryLog(binaryLog);
        return this.thisT();
    }

    @Override
    public T maxTraceEvents(int maxTraceEvents) {
        this.delegate().maxTraceEvents(maxTraceEvents);
        return this.thisT();
    }

    @Override
    public T proxyDetector(ProxyDetector proxyDetector) {
        this.delegate().proxyDetector(proxyDetector);
        return this.thisT();
    }

    @Override
    public T defaultServiceConfig(@Nullable Map<String, ?> serviceConfig) {
        this.delegate().defaultServiceConfig(serviceConfig);
        return this.thisT();
    }

    @Override
    public T disableServiceConfigLookUp() {
        this.delegate().disableServiceConfigLookUp();
        return this.thisT();
    }

    @Override
    public ManagedChannel build() {
        return this.delegate().build();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("delegate", this.delegate()).toString();
    }

    protected final T thisT() {
        AbstractManagedChannelImplBuilder thisT = this;
        return (T)thisT;
    }
}

