/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.python;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.environment.EnvironmentUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.zeppelin.interpreter.Interpreter;
import org.apache.zeppelin.interpreter.InterpreterContext;
import org.apache.zeppelin.interpreter.InterpreterException;
import org.apache.zeppelin.interpreter.InterpreterGroup;
import org.apache.zeppelin.interpreter.InterpreterHookRegistry;
import org.apache.zeppelin.interpreter.InterpreterResult;
import org.apache.zeppelin.interpreter.InvalidHookException;
import org.apache.zeppelin.interpreter.ZeppelinContext;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.apache.zeppelin.interpreter.thrift.InterpreterCompletion;
import org.apache.zeppelin.interpreter.util.InterpreterOutputStream;
import org.apache.zeppelin.interpreter.util.ProcessLauncher;
import org.apache.zeppelin.python.IPythonInterpreter;
import org.apache.zeppelin.python.PythonUtils;
import org.apache.zeppelin.python.PythonZeppelinContext;
import org.apache.zeppelin.shaded.com.google.gson.Gson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import py4j.GatewayServer;

public class PythonInterpreter
extends Interpreter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PythonInterpreter.class);
    private static final int MAX_TIMEOUT_SEC = 30;
    private GatewayServer gatewayServer;
    protected PythonProcessLauncher pythonProcessLauncher;
    private File pythonWorkDir;
    protected boolean useBuiltinPy4j = true;
    private InterpreterOutputStream outputStream;
    private long pythonPid = -1L;
    private IPythonInterpreter iPythonInterpreter;
    private ZeppelinContext zeppelinContext;
    private String condaPythonExec;
    private PythonInterpretRequest pythonInterpretRequest = null;
    private Integer statementSetNotifier = 0;
    private Integer statementFinishedNotifier = 0;
    private String statementOutput = null;
    private boolean statementError = false;

    public PythonInterpreter(Properties property) {
        super(property);
    }

    public void open() throws InterpreterException {
        this.iPythonInterpreter = this.getIPythonInterpreter();
        boolean useIPython = Boolean.parseBoolean(this.getProperty("zeppelin.python.useIPython", "true"));
        LOGGER.info("zeppelin.python.useIPython: {}", (Object)useIPython);
        if (useIPython) {
            String checkKernelPrerequisiteResult = this.iPythonInterpreter.checkKernelPrerequisite(this.getPythonExec());
            if (StringUtils.isEmpty(checkKernelPrerequisiteResult)) {
                try {
                    this.iPythonInterpreter.open();
                    LOGGER.info("IPython is available, Use IPythonInterpreter to replace PythonInterpreter");
                    return;
                }
                catch (Exception e) {
                    this.iPythonInterpreter = null;
                    LOGGER.warn("Fail to open IPythonInterpreter", e);
                }
            } else {
                LOGGER.info("IPython requirement is not met, checkKernelPrerequisiteResult: {}", (Object)checkKernelPrerequisiteResult);
            }
        }
        this.iPythonInterpreter = null;
        LOGGER.info("IPython is not available, use the native PythonInterpreter");
        InterpreterGroup intpGroup = this.getInterpreterGroup();
        if (intpGroup != null && intpGroup.getInterpreterHookRegistry() != null) {
            try {
                this.registerHook(InterpreterHookRegistry.HookType.POST_EXEC_DEV.getName(), "__zeppelin__._displayhook()");
            }
            catch (InvalidHookException e) {
                throw new InterpreterException((Throwable)e);
            }
        }
        try {
            this.createGatewayServerAndStartScript();
        }
        catch (IOException e) {
            LOGGER.error("Fail to open PythonInterpreter", e);
            throw new InterpreterException("Fail to open PythonInterpreter", (Throwable)e);
        }
    }

    private void createGatewayServerAndStartScript() throws IOException {
        int port = RemoteInterpreterUtils.findRandomAvailablePortOnAllLocalInterfaces();
        String serverAddress = PythonUtils.getLocalIP(this.properties);
        String secret = PythonUtils.createSecret(256);
        this.gatewayServer = PythonUtils.createGatewayServer((Object)this, serverAddress, port, secret);
        this.gatewayServer.start();
        this.createPythonScript();
        String pythonExec = this.getPythonExec();
        CommandLine cmd = CommandLine.parse(pythonExec);
        if (!pythonExec.endsWith(".py")) {
            cmd.addArgument(this.pythonWorkDir + "/zeppelin_python.py", false);
        }
        cmd.addArgument(serverAddress, false);
        cmd.addArgument(Integer.toString(port), false);
        this.outputStream = new InterpreterOutputStream(LOGGER);
        Map<String, String> env = this.setupPythonEnv();
        env.put("PY4J_GATEWAY_SECRET", secret);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Launching Python Process Command: {} {}", (Object)cmd.getExecutable(), (Object)StringUtils.join((Object[])cmd.getArguments(), " "));
        }
        this.pythonProcessLauncher = new PythonProcessLauncher(cmd, env);
        this.pythonProcessLauncher.launch();
        this.pythonProcessLauncher.waitForReady(30000);
        if (!this.pythonProcessLauncher.isRunning()) {
            if (this.pythonProcessLauncher.isLaunchTimeout()) {
                throw new IOException("Launch python process is time out.\n" + this.pythonProcessLauncher.getErrorMessage());
            }
            throw new IOException("Fail to launch python process.\n" + this.pythonProcessLauncher.getErrorMessage());
        }
    }

    public PythonProcessLauncher getPythonProcessLauncher() {
        return this.pythonProcessLauncher;
    }

    private void createPythonScript() throws IOException {
        if (System.getProperty("os.name", "").contains("Mac")) {
            System.setProperty("java.io.tmpdir", "/tmp");
        }
        this.pythonWorkDir = Files.createTempDirectory("python", new FileAttribute[0]).toFile();
        this.pythonWorkDir.deleteOnExit();
        LOGGER.info("Create Python working dir: {}", (Object)this.pythonWorkDir.getAbsolutePath());
        this.copyResourceToPythonWorkDir("python/zeppelin_python.py", "zeppelin_python.py");
        this.copyResourceToPythonWorkDir("python/zeppelin_context.py", "zeppelin_context.py");
        this.copyResourceToPythonWorkDir("python/backend_zinline.py", "backend_zinline.py");
        this.copyResourceToPythonWorkDir("python/mpl_config.py", "mpl_config.py");
        this.copyResourceToPythonWorkDir("python/py4j-src-0.10.9.7.zip", "py4j-src-0.10.9.7.zip");
    }

    protected boolean useIPython() {
        return this.iPythonInterpreter != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyResourceToPythonWorkDir(String srcResourceName, String dstFileName) throws IOException {
        try (FileOutputStream out = null;){
            out = new FileOutputStream(this.pythonWorkDir.getAbsoluteFile() + "/" + dstFileName);
            IOUtils.copy(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(srcResourceName), (OutputStream)out);
        }
    }

    protected Map<String, String> setupPythonEnv() throws IOException {
        Map<String, String> env = EnvironmentUtils.getProcEnvironment();
        this.appendToPythonPath(env, this.pythonWorkDir.getAbsolutePath());
        if (this.useBuiltinPy4j) {
            this.appendToPythonPath(env, this.pythonWorkDir.getAbsolutePath() + "/py4j-src-0.10.9.7.zip");
        }
        LOGGER.info("PYTHONPATH: {}", (Object)env.get("PYTHONPATH"));
        return env;
    }

    private void appendToPythonPath(Map<String, String> env, String path) {
        if (!env.containsKey("PYTHONPATH")) {
            env.put("PYTHONPATH", path);
        } else {
            env.put("PYTHONPATH", env.get("PYTHONPATH") + File.pathSeparator + path);
        }
    }

    protected String getPythonExec() {
        String condaEnv = this.getProperty("zeppelin.interpreter.conda.env.name");
        if (StringUtils.isNotBlank(condaEnv)) {
            return condaEnv + "/bin/python";
        }
        if (this.condaPythonExec != null) {
            return this.condaPythonExec;
        }
        return this.getProperty("zeppelin.python", "python");
    }

    public File getPythonWorkDir() {
        return this.pythonWorkDir;
    }

    public void close() throws InterpreterException {
        if (this.iPythonInterpreter != null) {
            this.iPythonInterpreter.close();
            return;
        }
        if (this.pythonProcessLauncher != null && this.pythonProcessLauncher.isRunning()) {
            LOGGER.info("Kill python process");
            this.pythonProcessLauncher.stop();
        }
        if (this.gatewayServer != null) {
            this.gatewayServer.shutdown();
        }
        this.statementSetNotifier = 0;
        this.statementFinishedNotifier = 0;
    }

    public void setPythonExec(String pythonExec) {
        LOGGER.info("Set Python Command : {}", (Object)pythonExec);
        this.condaPythonExec = pythonExec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PythonInterpretRequest getStatements() {
        Integer n = this.statementSetNotifier;
        synchronized (n) {
            while (this.pythonInterpretRequest == null) {
                try {
                    this.statementSetNotifier.wait(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            PythonInterpretRequest req = this.pythonInterpretRequest;
            this.pythonInterpretRequest = null;
            return req;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatementsFinished(String out, boolean error) {
        Integer n = this.statementFinishedNotifier;
        synchronized (n) {
            LOGGER.debug("Setting python statement output: {}, error: {}", (Object)out, (Object)error);
            this.statementOutput = out;
            this.statementError = error;
            this.statementFinishedNotifier.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPythonScriptInitialized(long pid) {
        this.pythonPid = pid;
        PythonProcessLauncher pythonProcessLauncher = this.pythonProcessLauncher;
        synchronized (pythonProcessLauncher) {
            LOGGER.debug("onPythonScriptInitialized is called");
            this.pythonProcessLauncher.initialized();
        }
    }

    public void appendOutput(String message) throws IOException {
        LOGGER.debug("Output from python process: {}", (Object)message);
        this.outputStream.getInterpreterOutput().write(message);
    }

    protected void preCallPython(InterpreterContext context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callPython(PythonInterpretRequest request) {
        Integer n = this.statementSetNotifier;
        synchronized (n) {
            this.pythonInterpretRequest = request;
            this.statementOutput = null;
            this.statementSetNotifier.notify();
        }
        n = this.statementFinishedNotifier;
        synchronized (n) {
            while (this.statementOutput == null && this.pythonProcessLauncher.isRunning()) {
                try {
                    this.statementFinishedNotifier.wait(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public InterpreterResult interpret(String st, InterpreterContext context) throws InterpreterException {
        if (this.iPythonInterpreter != null) {
            return this.iPythonInterpreter.interpret(st, context);
        }
        this.outputStream.setInterpreterOutput(context.out);
        ZeppelinContext z = this.getZeppelinContext();
        z.setInterpreterContext(context);
        z.setGui(context.getGui());
        z.setNoteGui(context.getNoteGui());
        InterpreterContext.set((InterpreterContext)context);
        this.preCallPython(context);
        this.callPython(new PythonInterpretRequest(st, false));
        if (this.statementError) {
            return new InterpreterResult(InterpreterResult.Code.ERROR, this.statementOutput);
        }
        try {
            context.out.flush();
        }
        catch (IOException e) {
            throw new InterpreterException((Throwable)e);
        }
        if (this.pythonProcessLauncher.isRunning()) {
            return new InterpreterResult(InterpreterResult.Code.SUCCESS);
        }
        return new InterpreterResult(InterpreterResult.Code.ERROR, "Python process is abnormally exited, please check your code and log.");
    }

    public void interrupt() throws IOException, InterpreterException {
        if (this.pythonPid > -1L) {
            LOGGER.info("Sending SIGINT signal to PID : {}", (Object)this.pythonPid);
            Runtime.getRuntime().exec("kill -SIGINT " + this.pythonPid);
        } else {
            LOGGER.warn("Non UNIX/Linux system, close the interpreter");
            this.close();
        }
    }

    public void cancel(InterpreterContext context) throws InterpreterException {
        if (this.iPythonInterpreter != null) {
            this.iPythonInterpreter.cancel(context);
            return;
        }
        try {
            this.interrupt();
        }
        catch (IOException e) {
            LOGGER.error("Error", e);
        }
    }

    public Interpreter.FormType getFormType() {
        return Interpreter.FormType.NATIVE;
    }

    public int getProgress(InterpreterContext context) throws InterpreterException {
        if (this.iPythonInterpreter != null) {
            return this.iPythonInterpreter.getProgress(context);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<InterpreterCompletion> completion(String buf, int cursor, InterpreterContext interpreterContext) throws InterpreterException {
        if (this.iPythonInterpreter != null) {
            return this.iPythonInterpreter.completion(buf, cursor, interpreterContext);
        }
        if (buf.length() < cursor) {
            cursor = buf.length();
        }
        String completionString = this.getCompletionTargetString(buf, cursor);
        String completionCommand = "__zeppelin_completion__.getCompletion('" + completionString + "')";
        LOGGER.debug("completionCommand: {}", (Object)completionCommand);
        this.pythonInterpretRequest = new PythonInterpretRequest(completionCommand, true);
        this.statementOutput = null;
        Integer n = this.statementSetNotifier;
        synchronized (n) {
            this.statementSetNotifier.notify();
        }
        String[] completionList = null;
        Integer n2 = this.statementFinishedNotifier;
        synchronized (n2) {
            long startTime = System.currentTimeMillis();
            while (this.statementOutput == null && this.pythonProcessLauncher.isRunning()) {
                try {
                    if (System.currentTimeMillis() - startTime > 30000L) {
                        LOGGER.error("Python completion didn't have response for {}sec.", (Object)30);
                        break;
                    }
                    this.statementFinishedNotifier.wait(1000L);
                }
                catch (InterruptedException e) {
                    LOGGER.info("wait drop");
                    return new LinkedList<InterpreterCompletion>();
                }
            }
            if (this.statementError) {
                return new LinkedList<InterpreterCompletion>();
            }
            Gson gson = new Gson();
            completionList = gson.fromJson(this.statementOutput, String[].class);
        }
        if (completionList == null) {
            return new LinkedList<InterpreterCompletion>();
        }
        LinkedList<InterpreterCompletion> results = new LinkedList<InterpreterCompletion>();
        for (String name : completionList) {
            results.add(new InterpreterCompletion(name, name, ""));
        }
        return results;
    }

    private String getCompletionTargetString(String text, int cursor) {
        String[] completionSeqCharaters = new String[]{" ", "\n", "\t"};
        int completionEndPosition = cursor;
        int completionStartPosition = cursor;
        int indexOfReverseSeqPostion = cursor;
        String resultCompletionText = "";
        String completionScriptText = "";
        try {
            completionScriptText = text.substring(0, cursor);
        }
        catch (Exception e) {
            LOGGER.error(e.toString());
            return null;
        }
        completionEndPosition = completionScriptText.length();
        String tempReverseCompletionText = new StringBuilder(completionScriptText).reverse().toString();
        for (String seqCharacter : completionSeqCharaters) {
            indexOfReverseSeqPostion = tempReverseCompletionText.indexOf(seqCharacter);
            if (indexOfReverseSeqPostion >= completionStartPosition || indexOfReverseSeqPostion <= 0) continue;
            completionStartPosition = indexOfReverseSeqPostion;
        }
        completionStartPosition = completionStartPosition == completionEndPosition ? 0 : completionEndPosition - completionStartPosition;
        resultCompletionText = completionScriptText.substring(completionStartPosition, completionEndPosition);
        return resultCompletionText;
    }

    protected IPythonInterpreter getIPythonInterpreter() throws InterpreterException {
        return (IPythonInterpreter)((Object)this.getInterpreterInTheSameSessionByClassName(IPythonInterpreter.class, false));
    }

    protected ZeppelinContext createZeppelinContext() {
        return new PythonZeppelinContext(this.getInterpreterGroup().getInterpreterHookRegistry(), Integer.parseInt(this.getProperty("zeppelin.python.maxResult", "1000")));
    }

    public ZeppelinContext getZeppelinContext() {
        if (this.zeppelinContext == null) {
            this.zeppelinContext = this.createZeppelinContext();
        }
        return this.zeppelinContext;
    }

    protected void bootstrapInterpreter(String resourceName) throws IOException {
        LOGGER.info("Bootstrap interpreter via {}", (Object)resourceName);
        String bootstrapCode = IOUtils.toString(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(resourceName));
        try {
            if (this.iPythonInterpreter != null) {
                InterpreterResult result = this.iPythonInterpreter.interpret(bootstrapCode, InterpreterContext.get());
                if (result.code() != InterpreterResult.Code.SUCCESS) {
                    throw new IOException("Fail to run bootstrap script: " + resourceName + "\n" + result);
                }
                LOGGER.debug("Bootstrap python successfully.");
            } else {
                InterpreterResult result = this.interpret(bootstrapCode + "\n__zeppelin__._displayhook()", InterpreterContext.get());
                if (result.code() != InterpreterResult.Code.SUCCESS) {
                    throw new IOException("Fail to run bootstrap script: " + resourceName + "\n" + result);
                }
                LOGGER.debug("Bootstrap python successfully.");
            }
        }
        catch (InterpreterException e) {
            throw new IOException(e);
        }
    }

    public void logPythonOutput(String message) {
        LOGGER.debug("Python Process Output: {}", (Object)message);
    }

    public class PythonProcessLauncher
    extends ProcessLauncher {
        PythonProcessLauncher(CommandLine commandLine, Map<String, String> envs) {
            super(commandLine, envs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForReady(int timeout) {
            long startTime = System.currentTimeMillis();
            PythonProcessLauncher pythonProcessLauncher = this;
            synchronized (pythonProcessLauncher) {
                while (this.state == ProcessLauncher.State.LAUNCHED) {
                    LOGGER.info("Waiting for python process initialized");
                    try {
                        ((Object)((Object)this)).wait(100L);
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e);
                    }
                    if (System.currentTimeMillis() - startTime <= (long)timeout) continue;
                    this.onTimeout();
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initialized() {
            PythonProcessLauncher pythonProcessLauncher = this;
            synchronized (pythonProcessLauncher) {
                this.state = ProcessLauncher.State.RUNNING;
                ((Object)((Object)this)).notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onProcessFailed(ExecuteException e) {
            super.onProcessFailed(e);
            Integer n = PythonInterpreter.this.statementFinishedNotifier;
            synchronized (n) {
                PythonInterpreter.this.statementFinishedNotifier.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onProcessComplete(int exitValue) {
            super.onProcessComplete(exitValue);
            Integer n = PythonInterpreter.this.statementFinishedNotifier;
            synchronized (n) {
                PythonInterpreter.this.statementFinishedNotifier.notify();
            }
        }
    }

    public class PythonInterpretRequest {
        public String statements;
        public boolean isForCompletion;
        public boolean isCallHooks;

        public PythonInterpretRequest(String statements, boolean isForCompletion) {
            this(statements, isForCompletion, true);
        }

        public PythonInterpretRequest(String statements, boolean isForCompletion, boolean isCallHooks) {
            this.statements = statements;
            this.isForCompletion = isForCompletion;
            this.isCallHooks = isCallHooks;
        }

        public String statements() {
            return this.statements;
        }

        public boolean isForCompletion() {
            return this.isForCompletion;
        }

        public boolean isCallHooks() {
            return this.isCallHooks;
        }
    }
}

