/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter.launcher;

import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.interpreter.launcher.InterpreterClient;
import org.apache.zeppelin.interpreter.launcher.InterpreterLaunchContext;
import org.apache.zeppelin.interpreter.launcher.InterpreterLauncher;
import org.apache.zeppelin.interpreter.launcher.K8sRemoteInterpreterProcess;
import org.apache.zeppelin.interpreter.launcher.K8sUtils;
import org.apache.zeppelin.interpreter.recovery.RecoveryStorage;
import org.apache.zeppelin.interpreter.remote.RemoteInterpreterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8sStandardInterpreterLauncher
extends InterpreterLauncher {
    private static final Logger LOGGER = LoggerFactory.getLogger(K8sStandardInterpreterLauncher.class);
    private final KubernetesClient client = new DefaultKubernetesClient();

    public K8sStandardInterpreterLauncher(ZeppelinConfiguration zConf, RecoveryStorage recoveryStorage) {
        super(zConf, recoveryStorage);
    }

    String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    private String getZeppelinService(InterpreterLaunchContext context) throws IOException {
        if (K8sUtils.isRunningOnKubernetes()) {
            String serverNamespace = K8sUtils.getCurrentK8sNamespace();
            return String.format("%s.%s.svc", this.zConf.getK8sServiceName(), serverNamespace);
        }
        return context.getIntpEventServerHost();
    }

    private int getZeppelinServiceRpcPort(InterpreterLaunchContext context) {
        String envServicePort = System.getenv(String.format("%s_SERVICE_PORT_RPC", this.getHostname().replaceAll("[-.]", "_").toUpperCase()));
        if (envServicePort != null) {
            return Integer.parseInt(envServicePort);
        }
        return context.getIntpEventServerPort();
    }

    private boolean isUserImpersonateForSparkInterpreter(InterpreterLaunchContext context) {
        return this.zConf.getZeppelinImpersonateSparkProxyUser() && context.getOption().isUserImpersonate() && "spark".equalsIgnoreCase(context.getInterpreterSettingGroup());
    }

    public InterpreterClient launchDirectly(InterpreterLaunchContext context) throws IOException {
        LOGGER.info("Launching Interpreter: {}", (Object)context.getInterpreterSettingGroup());
        return new K8sRemoteInterpreterProcess(this.client, K8sUtils.getInterpreterNamespace(context.getProperties(), this.zConf), new File(this.zConf.getK8sTemplatesDir(), "interpreter"), this.zConf.getK8sContainerImage(), context.getInterpreterGroupId(), context.getInterpreterSettingGroup(), context.getInterpreterSettingName(), context.getProperties(), this.buildEnvFromProperties(context), this.getZeppelinService(context), this.getZeppelinServiceRpcPort(context), this.zConf.getK8sPortForward(), this.zConf.getK8sSparkContainerImage(), this.getConnectTimeout(context), this.getConnectPoolSize(context), this.isUserImpersonateForSparkInterpreter(context), this.zConf.getK8sTimeoutDuringPending());
    }

    protected Map<String, String> buildEnvFromProperties(InterpreterLaunchContext context) {
        HashMap<String, String> env = new HashMap<String, String>();
        for (Object key : context.getProperties().keySet()) {
            if (RemoteInterpreterUtils.isEnvString((String)((String)key))) {
                env.put((String)key, context.getProperties().getProperty((String)key));
            }
            if (!key.toString().equals("FLINK_HOME")) continue;
            String flinkHome = context.getProperties().get(key).toString();
            env.put("FLINK_CONF_DIR", flinkHome + "/conf");
            env.put("FLINK_LIB_DIR", flinkHome + "/lib");
        }
        env.put("INTERPRETER_GROUP_ID", context.getInterpreterGroupId());
        return env;
    }
}

