/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.dep;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.zeppelin.conf.ZeppelinConfiguration;
import org.apache.zeppelin.dep.Booter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.zeppelin.org.eclipse.aether.RepositorySystem;
import shaded.org.apache.zeppelin.org.eclipse.aether.RepositorySystemSession;
import shaded.org.apache.zeppelin.org.eclipse.aether.repository.Authentication;
import shaded.org.apache.zeppelin.org.eclipse.aether.repository.Proxy;
import shaded.org.apache.zeppelin.org.eclipse.aether.repository.RemoteRepository;
import shaded.org.apache.zeppelin.org.eclipse.aether.repository.RepositoryPolicy;
import shaded.org.apache.zeppelin.org.eclipse.aether.resolution.ArtifactResult;
import shaded.org.apache.zeppelin.org.eclipse.aether.util.repository.AuthenticationBuilder;

public abstract class AbstractDependencyResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractDependencyResolver.class);
    protected RepositorySystem system = Booter.newRepositorySystem();
    protected List<RemoteRepository> repos = new LinkedList<RemoteRepository>();
    protected RepositorySystemSession session;
    private Proxy proxy = null;

    protected AbstractDependencyResolver(String localRepoPath, ZeppelinConfiguration zConf) {
        if (zConf.getZeppelinProxyUrl() != null) {
            try {
                URL proxyUrl = new URL(zConf.getZeppelinProxyUrl());
                Authentication auth = new AuthenticationBuilder().addUsername(zConf.getZeppelinProxyUser()).addPassword(zConf.getZeppelinProxyPassword()).build();
                this.proxy = new Proxy(proxyUrl.getProtocol(), proxyUrl.getHost(), proxyUrl.getPort(), auth);
            }
            catch (MalformedURLException e) {
                LOGGER.error("Proxy Url {} is not valid - skipping Proxy config", (Object)zConf.getZeppelinProxyUrl(), (Object)e);
            }
        }
        this.session = Booter.newRepositorySystemSession(this.system, localRepoPath);
        this.repos.addAll(Booter.newCentralRepositorys(this.proxy, zConf));
        this.repos.add(Booter.newLocalRepository());
    }

    protected AbstractDependencyResolver(String localRepoPath, Proxy proxy, ZeppelinConfiguration zConf) {
        this.proxy = proxy;
        this.session = Booter.newRepositorySystemSession(this.system, localRepoPath);
        this.repos.addAll(Booter.newCentralRepositorys(proxy, zConf));
        this.repos.add(Booter.newLocalRepository());
    }

    public List<RemoteRepository> getRepos() {
        return this.repos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepo(String id, String url, boolean snapshot) {
        List<RemoteRepository> list = this.repos;
        synchronized (list) {
            this.delRepo(id);
            RepositoryPolicy policy = new RepositoryPolicy(true, "daily", "warn");
            RemoteRepository.Builder rr = new RemoteRepository.Builder(id, "default", url);
            if (snapshot) {
                rr.setSnapshotPolicy(policy);
            } else {
                rr.setPolicy(policy);
            }
            if (this.proxy != null) {
                rr.setProxy(this.proxy);
            }
            this.repos.add(rr.build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRepo(String id, String url, boolean snapshot, Authentication auth, Proxy proxy) {
        List<RemoteRepository> list = this.repos;
        synchronized (list) {
            this.delRepo(id);
            RepositoryPolicy policy = new RepositoryPolicy(true, "daily", "warn");
            RemoteRepository.Builder rr = new RemoteRepository.Builder(id, "default", url).setAuthentication(auth).setProxy(proxy);
            if (snapshot) {
                rr.setSnapshotPolicy(policy);
            } else {
                rr.setPolicy(policy);
            }
            this.repos.add(rr.build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteRepository delRepo(String id) {
        List<RemoteRepository> list = this.repos;
        synchronized (list) {
            Iterator<RemoteRepository> it = this.repos.iterator();
            while (it.hasNext()) {
                RemoteRepository repo = it.next();
                if (!repo.getId().equals(id)) continue;
                it.remove();
                return repo;
            }
        }
        return null;
    }

    public abstract List<ArtifactResult> getArtifactsWithDep(String var1, Collection<String> var2) throws Exception;
}

