/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.interpreter;

import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import org.apache.zeppelin.common.JsonSerializable;
import org.apache.zeppelin.interpreter.InterpreterOutput;
import org.apache.zeppelin.interpreter.InterpreterResultMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.org.apache.zeppelin.com.google.gson.Gson;

public class InterpreterResult
implements Serializable,
JsonSerializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterpreterResult.class);
    private static final Gson gson = new Gson();
    Code code;
    List<InterpreterResultMessage> msg = new LinkedList<InterpreterResultMessage>();

    public InterpreterResult(Code code) {
        this.code = code;
    }

    public InterpreterResult(Code code, List<InterpreterResultMessage> msgs) {
        this.code = code;
        this.msg.addAll(msgs);
    }

    public InterpreterResult(Code code, String msg) {
        this.code = code;
        this.add(msg);
    }

    public InterpreterResult(Code code, Type type, String msg) {
        this.code = code;
        this.add(type, msg);
    }

    public void add(String msg) {
        InterpreterOutput out = new InterpreterOutput();
        try {
            out.write(msg);
            out.flush();
            this.msg.addAll(out.toInterpreterResultMessage());
            out.close();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    public void add(Type type, String data) {
        this.msg.add(new InterpreterResultMessage(type, data));
    }

    public void add(InterpreterResultMessage interpreterResultMessage) {
        this.msg.add(interpreterResultMessage);
    }

    public Code code() {
        return this.code;
    }

    public List<InterpreterResultMessage> message() {
        return this.msg;
    }

    @Override
    public String toJson() {
        return gson.toJson(this);
    }

    public static InterpreterResult fromJson(String json) {
        return gson.fromJson(json, InterpreterResult.class);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Type prevType = null;
        for (InterpreterResultMessage m : this.msg) {
            if (prevType != null) {
                sb.append("\n");
                if (prevType == Type.TABLE) {
                    sb.append("\n");
                }
            }
            sb.append(m.toString());
            prevType = m.getType();
        }
        return sb.toString();
    }

    public static enum Type {
        TEXT,
        HTML,
        ANGULAR,
        TABLE,
        IMG,
        SVG,
        NULL,
        NETWORK;

    }

    public static enum Code {
        SUCCESS,
        INCOMPLETE,
        ERROR,
        KEEP_PREVIOUS_RESULT;

    }
}

