/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zeppelin.resource;

import java.util.Collection;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.apache.zeppelin.common.JsonSerializable;
import org.apache.zeppelin.resource.Resource;
import shaded.org.apache.zeppelin.com.google.gson.Gson;

public class ResourceSet
extends LinkedList<Resource>
implements JsonSerializable {
    private static final Gson gson = new Gson();

    public ResourceSet(Collection<Resource> resources) {
        super(resources);
    }

    public ResourceSet() {
    }

    public ResourceSet filterByNameRegex(String regex) {
        ResourceSet result = new ResourceSet();
        for (Resource r : this) {
            if (!Pattern.matches(regex, r.getResourceId().getName())) continue;
            result.add(r);
        }
        return result;
    }

    public ResourceSet filterByName(String name) {
        ResourceSet result = new ResourceSet();
        for (Resource r : this) {
            if (!r.getResourceId().getName().equals(name)) continue;
            result.add(r);
        }
        return result;
    }

    public ResourceSet filterByClassnameRegex(String regex) {
        ResourceSet result = new ResourceSet();
        for (Resource r : this) {
            if (!Pattern.matches(regex, r.getClassName())) continue;
            result.add(r);
        }
        return result;
    }

    public ResourceSet filterByClassname(String className) {
        ResourceSet result = new ResourceSet();
        for (Resource r : this) {
            if (!r.getClassName().equals(className)) continue;
            result.add(r);
        }
        return result;
    }

    public ResourceSet filterByNoteId(String noteId) {
        ResourceSet result = new ResourceSet();
        for (Resource r : this) {
            if (!this.equals(r.getResourceId().getNoteId(), noteId)) continue;
            result.add(r);
        }
        return result;
    }

    public ResourceSet filterByParagraphId(String paragraphId) {
        ResourceSet result = new ResourceSet();
        for (Resource r : this) {
            if (!this.equals(r.getResourceId().getParagraphId(), paragraphId)) continue;
            result.add(r);
        }
        return result;
    }

    private boolean equals(String a, String b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null) {
            return a.equals(b);
        }
        return false;
    }

    @Override
    public String toJson() {
        return gson.toJson(this);
    }

    public static ResourceSet fromJson(String json) {
        return gson.fromJson(json, ResourceSet.class);
    }
}

