/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.inject;

import java.lang.annotation.Annotation;
import javax.inject.Provider;
import org.eclipse.sisu.Description;
import org.eclipse.sisu.Priority;
import org.eclipse.sisu.inject.DeferredProvider;
import org.eclipse.sisu.inject.DescriptionSource;
import org.eclipse.sisu.inject.Guice4;
import org.eclipse.sisu.inject.PrioritySource;
import shaded.org.apache.zeppelin.com.google.inject.Binding;
import shaded.org.apache.zeppelin.com.google.inject.servlet.InstanceFilterBinding;
import shaded.org.apache.zeppelin.com.google.inject.servlet.InstanceServletBinding;
import shaded.org.apache.zeppelin.com.google.inject.servlet.LinkedFilterBinding;
import shaded.org.apache.zeppelin.com.google.inject.servlet.LinkedServletBinding;
import shaded.org.apache.zeppelin.com.google.inject.servlet.ServletModuleTargetVisitor;
import shaded.org.apache.zeppelin.com.google.inject.spi.BindingTargetVisitor;
import shaded.org.apache.zeppelin.com.google.inject.spi.ConstructorBinding;
import shaded.org.apache.zeppelin.com.google.inject.spi.DefaultBindingTargetVisitor;
import shaded.org.apache.zeppelin.com.google.inject.spi.ExposedBinding;
import shaded.org.apache.zeppelin.com.google.inject.spi.InstanceBinding;
import shaded.org.apache.zeppelin.com.google.inject.spi.LinkedKeyBinding;
import shaded.org.apache.zeppelin.com.google.inject.spi.ProviderInstanceBinding;
import shaded.org.apache.zeppelin.com.google.inject.spi.UntargettedBinding;

final class Implementations {
    private static final boolean HAS_GUICE_SERVLET;
    private static final boolean HAS_JSR250_PRIORITY;

    static {
        boolean hasJsr250Priority;
        boolean hasGuiceServlet;
        try {
            hasGuiceServlet = BindingTargetVisitor.class.isInstance(ServletFinder.THIS);
        }
        catch (LinkageError linkageError) {
            hasGuiceServlet = false;
        }
        HAS_GUICE_SERVLET = hasGuiceServlet;
        try {
            hasJsr250Priority = javax.annotation.Priority.class.isAnnotation();
        }
        catch (LinkageError linkageError) {
            hasJsr250Priority = false;
        }
        HAS_JSR250_PRIORITY = hasJsr250Priority;
    }

    private Implementations() {
    }

    public static Class<?> find(Binding<?> binding) {
        return (Class)binding.acceptTargetVisitor(ClassFinder.THIS);
    }

    public static <T extends Annotation> T getAnnotation(Binding<?> binding, Class<T> annotationType) {
        boolean isPriority = Priority.class.equals(annotationType);
        Class implementation = (Class)binding.acceptTargetVisitor(HAS_GUICE_SERVLET && isPriority ? ServletFinder.THIS : ClassFinder.THIS);
        T annotation = null;
        if (implementation != null && (annotation = (T)implementation.getAnnotation(annotationType)) == null) {
            if (HAS_JSR250_PRIORITY && isPriority) {
                annotation = Implementations.adaptJsr250(binding, implementation);
            } else if (Description.class.equals(annotationType)) {
                annotation = Implementations.adaptLegacy(binding, implementation);
            }
        }
        return annotation;
    }

    private static <T extends Annotation> T adaptJsr250(Binding<?> binding, Class<?> clazz) {
        javax.annotation.Priority jsr250 = clazz.getAnnotation(javax.annotation.Priority.class);
        return (T)(jsr250 != null ? new PrioritySource(binding.getSource(), jsr250.value()) : null);
    }

    private static <T extends Annotation> T adaptLegacy(Binding<?> binding, Class<?> clazz) {
        org.sonatype.inject.Description legacy = clazz.getAnnotation(org.sonatype.inject.Description.class);
        return (T)(legacy != null ? new DescriptionSource(binding.getSource(), legacy.value()) : null);
    }

    static class ClassFinder
    extends DefaultBindingTargetVisitor<Object, Class<?>> {
        static final BindingTargetVisitor<Object, Class<?>> THIS = new ClassFinder();

        ClassFinder() {
        }

        public Class<?> visit(UntargettedBinding<?> binding) {
            return binding.getKey().getTypeLiteral().getRawType();
        }

        public Class<?> visit(LinkedKeyBinding<?> binding) {
            return binding.getLinkedKey().getTypeLiteral().getRawType();
        }

        public Class<?> visit(ConstructorBinding<?> binding) {
            return binding.getConstructor().getDeclaringType().getRawType();
        }

        public Class<?> visit(InstanceBinding<?> binding) {
            return binding.getInstance().getClass();
        }

        public Class<?> visit(ProviderInstanceBinding<?> binding) {
            Provider<?> provider = Guice4.getProviderInstance(binding);
            if (provider instanceof DeferredProvider) {
                try {
                    return ((DeferredProvider)((Object)provider)).getImplementationClass().load();
                }
                catch (TypeNotPresentException typeNotPresentException) {}
            }
            return null;
        }

        public Class<?> visit(ExposedBinding<?> binding) {
            return (Class)binding.getPrivateElements().getInjector().getBinding(binding.getKey()).acceptTargetVisitor((BindingTargetVisitor)this);
        }
    }

    static final class ServletFinder
    extends ClassFinder
    implements ServletModuleTargetVisitor<Object, Class<?>> {
        static final BindingTargetVisitor<Object, Class<?>> THIS = new ServletFinder();

        ServletFinder() {
        }

        public Class<?> visit(InstanceFilterBinding binding) {
            return binding.getFilterInstance().getClass();
        }

        public Class<?> visit(InstanceServletBinding binding) {
            return binding.getServletInstance().getClass();
        }

        public Class<?> visit(LinkedFilterBinding binding) {
            return binding.getLinkedKey().getTypeLiteral().getRawType();
        }

        public Class<?> visit(LinkedServletBinding binding) {
            return binding.getLinkedKey().getTypeLiteral().getRawType();
        }
    }
}

