/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.launch;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.sisu.inject.MutableBeanLocator;
import org.eclipse.sisu.launch.SisuExtensions;
import org.eclipse.sisu.space.BeanScanning;
import org.eclipse.sisu.space.BundleClassSpace;
import org.eclipse.sisu.space.ClassSpace;
import org.eclipse.sisu.space.SpaceModule;
import org.eclipse.sisu.wire.ParameterKeys;
import org.eclipse.sisu.wire.WireModule;
import shaded.org.apache.zeppelin.com.google.inject.Binder;
import shaded.org.apache.zeppelin.com.google.inject.Module;
import shaded.org.apache.zeppelin.org.osgi.framework.Bundle;
import shaded.org.apache.zeppelin.org.osgi.framework.BundleContext;

public class BundleModule
implements Module {
    protected final BundleClassSpace space;
    protected final SisuExtensions extensions;
    protected final MutableBeanLocator locator;

    public BundleModule(Bundle bundle, MutableBeanLocator locator) {
        this.space = new BundleClassSpace(bundle);
        this.extensions = SisuExtensions.local(this.space);
        this.locator = locator;
    }

    public void configure(Binder binder) {
        new WireModule(this.modules()).with(this.extensions).configure(binder);
    }

    protected Map<?, ?> getProperties() {
        return System.getProperties();
    }

    protected List<Module> modules() {
        return Arrays.asList(this.extensionsModule(), this.contextModule(), this.spaceModule());
    }

    protected Module extensionsModule() {
        return new Module(){

            public void configure(Binder binder) {
                BundleModule.this.extensions.install(binder, Bundle.class, BundleModule.this.space.getBundle());
            }
        };
    }

    protected Module contextModule() {
        return new Module(){

            public void configure(Binder binder) {
                binder.bind(MutableBeanLocator.class).toInstance((Object)BundleModule.this.locator);
                Bundle bundle = BundleModule.this.space.getBundle();
                binder.bind(ParameterKeys.PROPERTIES).toInstance(BundleModule.this.getProperties());
                binder.bind(BundleContext.class).toInstance((Object)bundle.getBundleContext());
            }
        };
    }

    protected Module spaceModule() {
        return new SpaceModule((ClassSpace)this.space, BeanScanning.select(this.getProperties())).with(this.extensions);
    }
}

