/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.plexus;

import java.util.Arrays;
import java.util.List;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.annotations.Requirement;

public final class Hints {
    public static final String[] NO_HINTS = new String[0];
    public static final String DEFAULT_HINT = "default";
    private static final List<String> NO_HINTS_LIST = Arrays.asList(NO_HINTS);

    private Hints() {
    }

    public static String canonicalHint(String hint) {
        return hint == null || hint.length() == 0 ? DEFAULT_HINT : hint.intern();
    }

    public static boolean isDefaultHint(String hint) {
        return DEFAULT_HINT.equals(hint) || hint == null || hint.length() == 0;
    }

    public static String[] canonicalHints(String ... hints) {
        int length = hints.length;
        if (length == 0 || length == 1 && hints[0].length() == 0) {
            return NO_HINTS;
        }
        int i = 0;
        while (i < length) {
            hints[i] = Hints.canonicalHint(hints[i]);
            ++i;
        }
        return hints;
    }

    public static List<String> canonicalHints(List<String> hints) {
        int length = hints.size();
        if (length == 0 || length == 1 && hints.get(0).length() == 0) {
            return NO_HINTS_LIST;
        }
        int i = 0;
        while (i < length) {
            hints.set(i, Hints.canonicalHint(hints.get(i)));
            ++i;
        }
        return hints;
    }

    public static String[] canonicalHints(Requirement requirement) {
        String[] hints = requirement.hints();
        if (hints.length > 0) {
            return Hints.canonicalHints(hints);
        }
        String hint = requirement.hint();
        if (hint.length() > 0) {
            return Hints.canonicalHints(hint);
        }
        return NO_HINTS;
    }
}

