/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.wire;

import org.eclipse.sisu.inject.Logs;
import org.eclipse.sisu.inject.TypeArguments;
import shaded.org.apache.zeppelin.com.google.inject.Binding;
import shaded.org.apache.zeppelin.com.google.inject.Key;
import shaded.org.apache.zeppelin.com.google.inject.TypeLiteral;
import shaded.org.apache.zeppelin.com.google.inject.spi.DefaultBindingTargetVisitor;
import shaded.org.apache.zeppelin.com.google.inject.spi.InjectionPoint;
import shaded.org.apache.zeppelin.com.google.inject.spi.LinkedKeyBinding;
import shaded.org.apache.zeppelin.com.google.inject.spi.UntargettedBinding;

final class DependencyVerifier
extends DefaultBindingTargetVisitor<Object, Boolean> {
    DependencyVerifier() {
    }

    public Boolean visit(UntargettedBinding<?> binding) {
        return DependencyVerifier.verifyImplementation(binding.getKey().getTypeLiteral());
    }

    public Boolean visit(LinkedKeyBinding<?> binding) {
        Key linkedKey = binding.getLinkedKey();
        if (linkedKey.getAnnotationType() == null) {
            return DependencyVerifier.verifyImplementation(linkedKey.getTypeLiteral());
        }
        return Boolean.TRUE;
    }

    public Boolean visitOther(Binding<?> binding) {
        return Boolean.TRUE;
    }

    private static Boolean verifyImplementation(TypeLiteral<?> type) {
        if (TypeArguments.isConcrete(type) && !type.toString().startsWith("java")) {
            try {
                InjectionPoint.forInstanceMethodsAndFields(type);
                InjectionPoint.forConstructorOf(type);
            }
            catch (RuntimeException e) {
                Logs.trace("Potential problem: {}", type, e);
                return Boolean.FALSE;
            }
            catch (LinkageError e) {
                Logs.trace("Potential problem: {}", type, e);
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }
}

