/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.wire;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import shaded.org.apache.zeppelin.com.google.inject.Injector;
import shaded.org.apache.zeppelin.com.google.inject.Singleton;
import shaded.org.apache.zeppelin.com.google.inject.TypeLiteral;
import shaded.org.apache.zeppelin.com.google.inject.spi.TypeConverter;
import shaded.org.apache.zeppelin.com.google.inject.spi.TypeConverterBinding;

@Singleton
final class TypeConverterCache {
    private final Map<TypeLiteral<?>, TypeConverter> converterMap = new ConcurrentHashMap(16, 0.75f, 1);
    private final Injector injector;

    @Inject
    TypeConverterCache(Injector injector) {
        this.injector = injector;
    }

    public TypeConverter getTypeConverter(TypeLiteral<?> type) {
        TypeConverter converter = this.converterMap.get(type);
        if (converter == null) {
            for (TypeConverterBinding b : this.injector.getTypeConverterBindings()) {
                if (!b.getTypeMatcher().matches(type)) continue;
                converter = b.getTypeConverter();
                this.converterMap.put(type, converter);
                break;
            }
        }
        return converter;
    }
}

