/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.composite;

import java.lang.reflect.Modifier;
import java.util.Properties;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.ConfigurationListener;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import shaded.org.apache.zeppelin.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import shaded.org.apache.zeppelin.org.codehaus.plexus.configuration.PlexusConfiguration;

public class PropertiesConverter
extends AbstractConfigurationConverter {
    @Override
    public boolean canConvert(Class<?> type) {
        return Properties.class.isAssignableFrom(type);
    }

    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        Object value = this.fromExpression(configuration, evaluator, type);
        if (value != null) {
            return value;
        }
        try {
            Properties properties = this.instantiateProperties(configuration, type, loader);
            int i = 0;
            int size = configuration.getChildCount();
            while (i < size) {
                PlexusConfiguration element = configuration.getChild(i);
                if ("property".equals(element.getName()) && element.getChildCount() > 0) {
                    Object name = this.fromExpression(element.getChild("name"), evaluator);
                    this.setProperty(properties, name, element.getChild("value"), evaluator);
                } else if (element.getChildCount() == 0) {
                    this.setProperty(properties, element.getName(), element, evaluator);
                }
                ++i;
            }
            return properties;
        }
        catch (ComponentConfigurationException e) {
            if (e.getFailedConfiguration() == null) {
                e.setFailedConfiguration(configuration);
            }
            throw e;
        }
    }

    private Properties instantiateProperties(PlexusConfiguration configuration, Class<?> type, ClassLoader loader) throws ComponentConfigurationException {
        Class<?> implType = this.getClassForImplementationHint(type, configuration, loader);
        if (implType == null || Modifier.isAbstract(implType.getModifiers())) {
            return new Properties();
        }
        Object impl = this.instantiateObject(implType);
        this.failIfNotTypeCompatible(impl, type, configuration);
        return (Properties)impl;
    }

    private void setProperty(Properties properties, Object name, PlexusConfiguration valueConfiguration, ExpressionEvaluator evaluator) throws ComponentConfigurationException {
        String key;
        String string = key = name != null ? name.toString() : null;
        if (key == null) {
            throw new ComponentConfigurationException("Missing name in properties");
        }
        Object value = this.fromExpression(valueConfiguration, evaluator);
        properties.setProperty(key, value != null ? value.toString() : "");
    }
}

