/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.unscramble;

import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.icons.AllIcons;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.threadDumpParser.ThreadDumpParser;
import com.intellij.threadDumpParser.ThreadState;
import com.intellij.unscramble.AnalyzeStacktraceUtil;
import com.intellij.unscramble.ThreadDumpConsoleFactory;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public final class UnscrambleUtils {
    private static final Condition<ThreadState> DEADLOCK_CONDITION = state -> state.isDeadlocked();
    private static final Pattern STACKTRACE_LINE = Pattern.compile("[\t]*at [[_a-zA-Z0-9/]+\\.]+[_a-zA-Z$0-9/]+\\.[a-zA-Z0-9_/]+\\([A-Za-z0-9_/]+\\.(java|kt):[\\d]+\\)+[ [~]*\\[[a-zA-Z0-9\\.\\:/]\\]]*");

    @Nullable
    public static String getExceptionName(String unscrambledTrace) {
        BufferedReader reader = new BufferedReader(new StringReader(unscrambledTrace));
        for (int i = 0; i < 3; ++i) {
            try {
                String line = reader.readLine();
                if (line == null) {
                    return null;
                }
                String name = UnscrambleUtils.getExceptionAbbreviation(line);
                if (name == null) continue;
                return name;
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    @Nullable
    private static String getExceptionAbbreviation(String line) {
        line = StringUtil.trimStart((String)line.trim(), (String)"Caused by: ");
        int classNameStart = 0;
        int classNameEnd = line.length();
        for (int j = 0; j < line.length(); ++j) {
            char c = line.charAt(j);
            if (c == '.' || c == '$') {
                classNameStart = j + 1;
                continue;
            }
            if (c == ':') {
                classNameEnd = j;
                break;
            }
            if (StringUtil.isJavaIdentifierPart((char)c)) continue;
            return null;
        }
        if (classNameStart >= classNameEnd) {
            return null;
        }
        String clazz = line.substring(classNameStart, classNameEnd);
        String abbreviate = UnscrambleUtils.abbreviate(clazz);
        return abbreviate.length() > 1 ? abbreviate : clazz;
    }

    private static String abbreviate(String s) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (!Character.isUpperCase(c)) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    public static RunContentDescriptor addConsole(Project project, List<ThreadState> threadDump, String unscrambledTrace, Boolean withExecutor) {
        Icon icon = null;
        String message = JavaBundle.message((String)"unscramble.unscrambled.stacktrace.tab", (Object[])new Object[0]);
        if (!threadDump.isEmpty()) {
            message = JavaBundle.message((String)"unscramble.unscrambled.threaddump.tab", (Object[])new Object[0]);
            icon = AllIcons.Actions.Dump;
        } else {
            String name = UnscrambleUtils.getExceptionName(unscrambledTrace);
            if (name != null) {
                message = name;
                icon = AllIcons.Actions.Lightning;
            }
        }
        if (ContainerUtil.find(threadDump, DEADLOCK_CONDITION) != null) {
            message = JavaBundle.message((String)"unscramble.unscrambled.deadlock.tab", (Object[])new Object[0]);
            icon = AllIcons.Debugger.KillProcess;
        }
        return AnalyzeStacktraceUtil.addConsole((Project)project, (AnalyzeStacktraceUtil.ConsoleFactory)(threadDump.size() > 1 ? new ThreadDumpConsoleFactory(project, threadDump) : null), (String)message, (String)unscrambledTrace, (Icon)icon, (boolean)withExecutor);
    }

    public static RunContentDescriptor addConsole(Project project, List<ThreadState> threadDump, String unscrambledTrace) {
        return UnscrambleUtils.addConsole(project, threadDump, unscrambledTrace, true);
    }

    public static boolean isStackTrace(String text) {
        text = ThreadDumpParser.normalizeText((String)text);
        int linesCount = 0;
        for (String line : text.split("\n")) {
            if ((line = line.trim()).isEmpty()) continue;
            linesCount = STACKTRACE_LINE.matcher(line = StringUtil.trimEnd((String)line, (String)"\r")).matches() ? ++linesCount : 0;
            if (linesCount <= 2) continue;
            return true;
        }
        return false;
    }
}

