/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.math;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedFloatingPointRange;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlinx.dataframe.math.QuantileKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bp\u0018\u0000 \u0012*\u000e\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u0002*\b\b\u0001\u0010\u0003*\u00020\u00042\u00020\u0005:\u0003\u0010\u0011\u0012J\u001d\u0010\u0006\u001a\u00028\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&\u00a2\u0006\u0002\u0010\u000bJ#\u0010\f\u001a\u00028\u00002\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u000eH&\u00a2\u0006\u0002\u0010\u000f\u0082\u0001\u0002\u0013\u0014\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0015\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod;", "Value", "", "Index", "", "", "oneBasedIndexOfQuantile", "p", "", "count", "", "(DI)Ljava/lang/Number;", "quantile", "values", "", "(DLjava/util/List;)Ljava/lang/Comparable;", "Selecting", "Interpolating", "Companion", "Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Interpolating;", "Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Selecting;", "core"})
public interface QuantileEstimationMethod<Value extends Comparable<? super Value>, Index extends Number> {
    @NotNull
    public static final Companion Companion = org.jetbrains.kotlinx.dataframe.math.QuantileEstimationMethod$Companion.$$INSTANCE;

    @NotNull
    public Index oneBasedIndexOfQuantile(double var1, int var3);

    @NotNull
    public Value quantile(double var1, @NotNull List<? extends Value> var3);

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Companion;", "", "<init>", "()V", "R1", "Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Selecting$R1;", "getR1", "()Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Selecting$R1;", "R3", "Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Selecting$R3;", "getR3", "()Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Selecting$R3;", "R7", "Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Interpolating$R7;", "getR7", "()Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Interpolating$R7;", "R8", "Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Interpolating$R8;", "getR8", "()Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Interpolating$R8;", "core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;
        @NotNull
        private static final Selecting.R1 R1;
        @NotNull
        private static final Selecting.R3 R3;
        @NotNull
        private static final Interpolating.R7 R7;
        @NotNull
        private static final Interpolating.R8 R8;

        private Companion() {
        }

        @NotNull
        public final Selecting.R1 getR1() {
            return R1;
        }

        @NotNull
        public final Selecting.R3 getR3() {
            return R3;
        }

        @NotNull
        public final Interpolating.R7 getR7() {
            return R7;
        }

        @NotNull
        public final Interpolating.R8 getR8() {
            return R8;
        }

        static {
            $$INSTANCE = new Companion();
            R1 = Selecting.R1.INSTANCE;
            R3 = Selecting.R3.INSTANCE;
            R7 = Interpolating.R7.INSTANCE;
            R8 = Interpolating.R8.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u0003\u0004\u0005\u0082\u0001\u0003\u0006\u0007\b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Interpolating;", "Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod;", "", "R7", "R8", "PieceWiseLinear", "Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Interpolating$PieceWiseLinear;", "Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Interpolating$R7;", "Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Interpolating$R8;", "core"})
    public static interface Interpolating
    extends QuantileEstimationMethod<Double, Double> {

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\bb\u0018\u00002\u00020\u0001J#\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006H\u0016\u00a2\u0006\u0002\u0010\u0007\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\b\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Interpolating$PieceWiseLinear;", "Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Interpolating;", "quantile", "", "p", "values", "", "(DLjava/util/List;)Ljava/lang/Double;", "core"})
        private static interface PieceWiseLinear
        extends Interpolating {
            @Override
            @NotNull
            default public Double quantile(double p, @NotNull List<Double> values) {
                Intrinsics.checkNotNullParameter(values, (String)"values");
                double h = ((Number)this.oneBasedIndexOfQuantile(p, values.size())).doubleValue();
                return ((Number)QuantileKt.quickSelect(values, (int)Math.floor(h) - 1)).doubleValue() + (h - Math.floor(h)) * (((Number)QuantileKt.quickSelect(values, (int)Math.ceil(h) - 1)).doubleValue() - ((Number)QuantileKt.quickSelect(values, (int)Math.floor(h) - 1)).doubleValue());
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\tH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Interpolating$R7;", "Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Interpolating;", "Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Interpolating$PieceWiseLinear;", "<init>", "()V", "oneBasedIndexOfQuantile", "", "p", "count", "", "(DI)Ljava/lang/Double;", "equals", "", "other", "", "hashCode", "toString", "", "core"})
        public static final class R7
        implements Interpolating,
        PieceWiseLinear {
            @NotNull
            public static final R7 INSTANCE = new R7();

            private R7() {
            }

            @Override
            @NotNull
            public Double oneBasedIndexOfQuantile(double p, int count2) {
                return (Double)RangesKt.coerceIn((Comparable)Double.valueOf(((double)count2 - 1.0) * p + 1.0), (ClosedFloatingPointRange)RangesKt.rangeTo((double)1.0, (double)count2));
            }

            @NotNull
            public String toString() {
                return "R7";
            }

            public int hashCode() {
                return 1171885622;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof R7)) {
                    return false;
                }
                R7 cfr_ignored_0 = (R7)other;
                return true;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u00012\u00020\u0002B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001d\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u00d6\u0003J\t\u0010\u000f\u001a\u00020\tH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Interpolating$R8;", "Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Interpolating;", "Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Interpolating$PieceWiseLinear;", "<init>", "()V", "oneBasedIndexOfQuantile", "", "p", "count", "", "(DI)Ljava/lang/Double;", "equals", "", "other", "", "hashCode", "toString", "", "core"})
        public static final class R8
        implements Interpolating,
        PieceWiseLinear {
            @NotNull
            public static final R8 INSTANCE = new R8();

            private R8() {
            }

            @Override
            @NotNull
            public Double oneBasedIndexOfQuantile(double p, int count2) {
                return (Double)RangesKt.coerceIn((Comparable)Double.valueOf(((double)count2 + 0.3333333333333333) * p + 0.3333333333333333), (ClosedFloatingPointRange)RangesKt.rangeTo((double)1.0, (double)count2));
            }

            @NotNull
            public String toString() {
                return "R8";
            }

            public int hashCode() {
                return 1171885623;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof R8)) {
                    return false;
                }
                R8 cfr_ignored_0 = (R8)other;
                return true;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bv\u0018\u00002\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001:\u0002\u0005\u0006\u0082\u0001\u0002\u0007\b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Selecting;", "Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod;", "", "", "", "R1", "R3", "Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Selecting$R1;", "Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Selecting$R3;", "core"})
    public static interface Selecting
    extends QuantileEstimationMethod<Comparable<? super Object>, Integer> {

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\tJ*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u000eH\u0016J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Selecting$R1;", "Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Selecting;", "<init>", "()V", "oneBasedIndexOfQuantile", "", "p", "", "count", "(DI)Ljava/lang/Integer;", "quantile", "", "", "values", "", "equals", "", "other", "hashCode", "toString", "", "core"})
        public static final class R1
        implements Selecting {
            @NotNull
            public static final R1 INSTANCE = new R1();

            private R1() {
            }

            @Override
            @NotNull
            public Integer oneBasedIndexOfQuantile(double p, int count2) {
                return RangesKt.coerceIn((int)((int)Math.ceil(p * (double)count2)), (ClosedRange)((ClosedRange)new IntRange(1, count2)));
            }

            @Override
            @NotNull
            public Comparable<Object> quantile(double p, @NotNull List<? extends Comparable<Object>> values) {
                Intrinsics.checkNotNullParameter(values, (String)"values");
                int h = ((Number)QuantileKt.indexOfQuantile(this, p, values.size())).intValue();
                return QuantileKt.quickSelect(values, h);
            }

            @NotNull
            public String toString() {
                return "R1";
            }

            public int hashCode() {
                return -1394481720;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof R1)) {
                    return false;
                }
                R1 cfr_ignored_0 = (R1)other;
                return true;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005H\u0016\u00a2\u0006\u0002\u0010\tJ*\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u000eH\u0016J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Selecting$R3;", "Lorg/jetbrains/kotlinx/dataframe/math/QuantileEstimationMethod$Selecting;", "<init>", "()V", "oneBasedIndexOfQuantile", "", "p", "", "count", "(DI)Ljava/lang/Integer;", "quantile", "", "", "values", "", "equals", "", "other", "hashCode", "toString", "", "core"})
        public static final class R3
        implements Selecting {
            @NotNull
            public static final R3 INSTANCE = new R3();

            private R3() {
            }

            @Override
            @NotNull
            public Integer oneBasedIndexOfQuantile(double p, int count2) {
                return RangesKt.coerceIn((int)((int)Math.rint((double)count2 * p)), (ClosedRange)((ClosedRange)new IntRange(1, count2)));
            }

            @Override
            @NotNull
            public Comparable<Object> quantile(double p, @NotNull List<? extends Comparable<Object>> values) {
                Intrinsics.checkNotNullParameter(values, (String)"values");
                int h = ((Number)QuantileKt.indexOfQuantile(this, p, values.size())).intValue();
                return QuantileKt.quickSelect(values, h);
            }

            @NotNull
            public String toString() {
                return "R3";
            }

            public int hashCode() {
                return -1394481718;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof R3)) {
                    return false;
                }
                R3 cfr_ignored_0 = (R3)other;
                return true;
            }
        }
    }
}

