/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.server.share.fetch;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Random;
import java.util.Set;
import org.apache.kafka.common.TopicIdPartition;

public interface PartitionMaxBytesStrategy {
    public static final Random RANDOM = new Random();

    public LinkedHashMap<TopicIdPartition, Integer> maxBytes(int var1, Set<TopicIdPartition> var2, int var3);

    public static PartitionMaxBytesStrategy type(StrategyType type) {
        if (type == null) {
            throw new IllegalArgumentException("Strategy type cannot be null");
        }
        switch (type.ordinal()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case 0: 
        }
        return PartitionMaxBytesStrategy::uniformPartitionMaxBytes;
    }

    private static LinkedHashMap<TopicIdPartition, Integer> uniformPartitionMaxBytes(int requestMaxBytes, Set<TopicIdPartition> partitions, int acquiredPartitionsSize) {
        PartitionMaxBytesStrategy.checkValidArguments(requestMaxBytes, partitions, acquiredPartitionsSize);
        if (requestMaxBytes >= acquiredPartitionsSize) {
            return PartitionMaxBytesStrategy.allotUniformBytesToPartitions(partitions, requestMaxBytes, acquiredPartitionsSize);
        }
        if (requestMaxBytes >= partitions.size()) {
            return PartitionMaxBytesStrategy.allotUniformBytesToPartitions(partitions, requestMaxBytes, partitions.size());
        }
        LinkedHashMap<TopicIdPartition, Integer> partitionMaxBytes = new LinkedHashMap<TopicIdPartition, Integer>();
        partitions.forEach(partition -> partitionMaxBytes.put((TopicIdPartition)partition, 0));
        int randomIndex = RANDOM.nextInt(partitions.size());
        HashSet<Integer> nonEmptyPartitionIndexes = new HashSet<Integer>();
        for (int nonEmptyPartitionsCount = 0; nonEmptyPartitionsCount < requestMaxBytes; ++nonEmptyPartitionsCount) {
            nonEmptyPartitionIndexes.add(randomIndex);
            randomIndex = (randomIndex + 1) % partitions.size();
        }
        PartitionMaxBytesStrategy.allotBytesByPartitionIndex(1, partitions, partitionMaxBytes, nonEmptyPartitionIndexes);
        return partitionMaxBytes;
    }

    private static LinkedHashMap<TopicIdPartition, Integer> allotUniformBytesToPartitions(Set<TopicIdPartition> partitions, int requestMaxBytes, int partitionsSize) {
        LinkedHashMap<TopicIdPartition, Integer> partitionMaxBytes = new LinkedHashMap<TopicIdPartition, Integer>();
        int uniformPartitionBytes = requestMaxBytes / partitionsSize;
        int remainingBytes = requestMaxBytes % partitionsSize;
        partitions.forEach(partition -> partitionMaxBytes.put((TopicIdPartition)partition, uniformPartitionBytes));
        if (remainingBytes != 0) {
            int randomPartitionIndex = RANDOM.nextInt(partitionMaxBytes.keySet().size());
            PartitionMaxBytesStrategy.allotBytesByPartitionIndex(uniformPartitionBytes + remainingBytes, partitions, partitionMaxBytes, Set.of(Integer.valueOf(randomPartitionIndex)));
        }
        return partitionMaxBytes;
    }

    private static void allotBytesByPartitionIndex(int bytes, Set<TopicIdPartition> partitions, LinkedHashMap<TopicIdPartition, Integer> partitionMaxBytes, Set<Integer> partitionIndexesToAllot) {
        int index = 0;
        int count = 0;
        for (TopicIdPartition partition : partitions) {
            if (partitionIndexesToAllot.contains(index)) {
                partitionMaxBytes.put(partition, bytes);
                if (++count == partitionIndexesToAllot.size()) break;
            }
            ++index;
        }
    }

    public static void checkValidArguments(int requestMaxBytes, Set<TopicIdPartition> partitions, int acquiredPartitionsSize) {
        if (partitions == null || partitions.isEmpty()) {
            throw new IllegalArgumentException("Partitions to generate max bytes is null or empty");
        }
        if (requestMaxBytes <= 0) {
            throw new IllegalArgumentException("Request max bytes must be greater than 0");
        }
        if (acquiredPartitionsSize <= 0) {
            throw new IllegalArgumentException("Acquired partitions size must be greater than 0");
        }
    }

    public static enum StrategyType {
        UNIFORM;


        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }
    }
}

