/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.metadata;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.server.ConfigAdminManager$;
import kafka.server.ConfigHandler;
import kafka.server.KafkaConfig;
import kafka.utils.Logging;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.image.ConfigurationsDelta;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.image.loader.LoaderManifest;
import org.apache.kafka.image.publisher.MetadataPublisher;
import org.apache.kafka.raft.LeaderAndEpoch;
import org.apache.kafka.server.config.ConfigType;
import org.apache.kafka.server.fault.FaultHandler;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001da\u0001\u0002\u0006\f\u0001IA\u0001\u0002\f\u0001\u0003\u0002\u0003\u0006I!\f\u0005\tc\u0001\u0011\t\u0011)A\u0005e!A\u0011\b\u0001B\u0001B\u0003%!\b\u0003\u0005O\u0001\t\u0005\t\u0015!\u0003P\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0011\u0015Q\u0006\u0001\"\u0011\\\u0011\u0015a\u0006\u0001\"\u0011^\u0011\u0015a\u0006\u0001\"\u0001u\u0011\u00159\b\u0001\"\u0001y\u0005Y!\u0015P\\1nS\u000e\u001cuN\u001c4jOB+(\r\\5tQ\u0016\u0014(B\u0001\u0007\u000e\u0003!iW\r^1eCR\f'B\u0001\b\u0010\u0003\u0019\u0019XM\u001d<fe*\t\u0001#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\t\u0001\u0019\u0012d\b\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005iiR\"A\u000e\u000b\u0005qy\u0011!B;uS2\u001c\u0018B\u0001\u0010\u001c\u0005\u001daunZ4j]\u001e\u0004\"\u0001\t\u0016\u000e\u0003\u0005R!AI\u0012\u0002\u0013A,(\r\\5tQ\u0016\u0014(B\u0001\u0013&\u0003\u0015IW.Y4f\u0015\t\u0001bE\u0003\u0002(Q\u00051\u0011\r]1dQ\u0016T\u0011!K\u0001\u0004_J<\u0017BA\u0016\"\u0005EiU\r^1eCR\f\u0007+\u001e2mSNDWM]\u0001\u0005G>tg\r\u0005\u0002/_5\tQ\"\u0003\u00021\u001b\tY1*\u00194lC\u000e{gNZ5h\u000311\u0017-\u001e7u\u0011\u0006tG\r\\3s!\t\u0019t'D\u00015\u0015\t)d'A\u0003gCVdGO\u0003\u0002\u000fK%\u0011\u0001\b\u000e\u0002\r\r\u0006,H\u000e\u001e%b]\u0012dWM]\u0001\u0016Ift\u0017-\\5d\u0007>tg-[4IC:$G.\u001a:t!\u0011Y$)R&\u000f\u0005q\u0002\u0005CA\u001f\u0016\u001b\u0005q$BA \u0012\u0003\u0019a$o\\8u}%\u0011\u0011)F\u0001\u0007!J,G-\u001a4\n\u0005\r#%aA'ba*\u0011\u0011)\u0006\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011Z\naaY8oM&<\u0017B\u0001&H\u0005)\u0019uN\u001c4jORK\b/\u001a\t\u0003]1K!!T\u0007\u0003\u001b\r{gNZ5h\u0011\u0006tG\r\\3s\u0003!qw\u000eZ3UsB,\u0007CA\u001eQ\u0013\t\tFI\u0001\u0004TiJLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000bQ3v\u000bW-\u0011\u0005U\u0003Q\"A\u0006\t\u000b1*\u0001\u0019A\u0017\t\u000bE*\u0001\u0019\u0001\u001a\t\u000be*\u0001\u0019\u0001\u001e\t\u000b9+\u0001\u0019A(\u0002\t9\fW.\u001a\u000b\u0002\u001f\u0006\u0001rN\\'fi\u0006$\u0017\r^1Va\u0012\fG/\u001a\u000b\u0005=\u0006<G\u000e\u0005\u0002\u0015?&\u0011\u0001-\u0006\u0002\u0005+:LG\u000fC\u0003c\u000f\u0001\u00071-A\u0003eK2$\u0018\r\u0005\u0002eK6\t1%\u0003\u0002gG\tiQ*\u001a;bI\u0006$\u0018\rR3mi\u0006DQ\u0001[\u0004A\u0002%\f\u0001B\\3x\u00136\fw-\u001a\t\u0003I*L!a[\u0012\u0003\u001b5+G/\u00193bi\u0006LU.Y4f\u0011\u0015iw\u00011\u0001o\u0003!i\u0017M\\5gKN$\bCA8s\u001b\u0005\u0001(BA9$\u0003\u0019aw.\u00193fe&\u00111\u000f\u001d\u0002\u000f\u0019>\fG-\u001a:NC:Lg-Z:u)\rqVO\u001e\u0005\u0006E\"\u0001\ra\u0019\u0005\u0006Q\"\u0001\r![\u0001&e\u0016dw.\u00193Va\u0012\fG/\u001a3GS2,7oV5uQ>,HoQ8oM&<7\t[1oO\u0016$\"AX=\t\u000biL\u0001\u0019A>\u0002\u000bA\u0014x\u000e]:\u0011\u0007q\f\u0019!D\u0001~\u0015\tqx0\u0001\u0003vi&d'BAA\u0001\u0003\u0011Q\u0017M^1\n\u0007\u0005\u0015QP\u0001\u0006Qe>\u0004XM\u001d;jKN\u0004")
public class DynamicConfigPublisher
implements Logging,
MetadataPublisher {
    private final KafkaConfig conf;
    private final FaultHandler faultHandler;
    private final Map<ConfigType, ConfigHandler> dynamicConfigHandlers;
    private final String nodeType;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public void onControllerChange(LeaderAndEpoch x$1) {
        super.onControllerChange(x$1);
    }

    public void close() throws Exception {
        super.close();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return "DynamicConfigPublisher " + this.nodeType + " id=" + this.conf.nodeId();
    }

    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage, LoaderManifest manifest) {
        this.onMetadataUpdate(delta, newImage);
    }

    public void onMetadataUpdate(MetadataDelta delta, MetadataImage newImage) {
        String deltaName = "MetadataDelta up to " + newImage.highestOffsetAndEpoch().offset();
        try {
            Option$.MODULE$.apply((Object)delta.configsDelta()).foreach((Function1 & Serializable)configsDelta -> {
                DynamicConfigPublisher.$anonfun$onMetadataUpdate$1(this, newImage, deltaName, configsDelta);
                return BoxedUnit.UNIT;
            });
            return;
        }
        catch (Throwable t) {
            this.faultHandler.handleFault("Uncaught exception while publishing dynamic configuration changes from " + deltaName, t);
            return;
        }
    }

    public void reloadUpdatedFilesWithoutConfigChange(Properties props) {
        this.conf.dynamicConfig().reloadUpdatedFilesWithoutConfigChange(props);
    }

    public static final /* synthetic */ void $anonfun$onMetadataUpdate$1(DynamicConfigPublisher $this, MetadataImage newImage$1, String deltaName$1, ConfigurationsDelta configsDelta) {
        configsDelta.changes().keySet().forEach(resource -> {
            Properties props = newImage$1.configs().configProperties(resource);
            ConfigResource.Type type = resource.type();
            if (ConfigResource.Type.TOPIC.equals(type)) {
                $this.dynamicConfigHandlers.get((Object)ConfigType.TOPIC).foreach((Function1 & Serializable)topicConfigHandler -> {
                    try {
                        $this.info((Function0<String>)(Function0 & Serializable)() -> "Updating topic " + resource.name() + " with new configuration : " + ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(","));
                        topicConfigHandler.processConfigChanges(resource.name(), props);
                        return BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        return $this.faultHandler.handleFault("Error updating topic " + resource.name() + " with new configuration: " + ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",") + " in " + deltaName$1, t);
                    }
                });
                return;
            }
            if (ConfigResource.Type.BROKER.equals(type)) {
                $this.dynamicConfigHandlers.get((Object)ConfigType.BROKER).foreach((Function1 & Serializable)nodeConfigHandler -> {
                    if (resource.name().isEmpty()) {
                        try {
                            $this.info((Function0<String>)(Function0 & Serializable)() -> "Updating cluster configuration : " + ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(","));
                            nodeConfigHandler.processConfigChanges(resource.name(), props);
                            return BoxedUnit.UNIT;
                        }
                        catch (Throwable t) {
                            return $this.faultHandler.handleFault("Error updating cluster with new configuration: " + ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",") + " in " + deltaName$1, t);
                        }
                    }
                    String string = resource.name();
                    String string2 = Integer.toString($this.conf.nodeId());
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        try {
                            $this.info((Function0<String>)(Function0 & Serializable)() -> "Updating node " + $this.conf.nodeId() + " with new configuration : " + ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(","));
                            nodeConfigHandler.processConfigChanges(resource.name(), props);
                            $this.reloadUpdatedFilesWithoutConfigChange(props);
                            return BoxedUnit.UNIT;
                        }
                        catch (Throwable t) {
                            return $this.faultHandler.handleFault("Error updating node with new configuration: " + ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",") + " in " + deltaName$1, t);
                        }
                    }
                    return BoxedUnit.UNIT;
                });
                return;
            }
            if (ConfigResource.Type.CLIENT_METRICS.equals(type)) {
                $this.dynamicConfigHandlers.get((Object)ConfigType.CLIENT_METRICS).foreach((Function1 & Serializable)metricsConfigHandler -> {
                    try {
                        $this.info((Function0<String>)(Function0 & Serializable)() -> "Updating client metrics " + resource.name() + " with new configuration : " + ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(","));
                        metricsConfigHandler.processConfigChanges(resource.name(), props);
                        return BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        return $this.faultHandler.handleFault("Error updating client metrics" + resource.name() + " with new configuration: " + ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",") + " in " + deltaName$1, t);
                    }
                });
                return;
            }
            if (ConfigResource.Type.GROUP.equals(type)) {
                $this.dynamicConfigHandlers.get((Object)ConfigType.GROUP).foreach((Function1 & Serializable)groupConfigHandler -> {
                    try {
                        $this.info((Function0<String>)(Function0 & Serializable)() -> "Updating group " + resource.name() + " with new configuration : " + ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(","));
                        groupConfigHandler.processConfigChanges(resource.name(), props);
                        return BoxedUnit.UNIT;
                    }
                    catch (Throwable t) {
                        return $this.faultHandler.handleFault("Error updating group " + resource.name() + " with new configuration: " + ConfigAdminManager$.MODULE$.toLoggableProps((ConfigResource)resource, props).mkString(",") + " in " + deltaName$1, t);
                    }
                });
                return;
            }
        });
    }

    public DynamicConfigPublisher(KafkaConfig conf, FaultHandler faultHandler, Map<ConfigType, ConfigHandler> dynamicConfigHandlers, String nodeType) {
        this.conf = conf;
        this.faultHandler = faultHandler;
        this.dynamicConfigHandlers = dynamicConfigHandlers;
        this.nodeType = nodeType;
        this.logIdent_$eq("[" + this.name() + "] ");
    }
}

