---
title: Broker Configs
description: Broker Configs
weight: 1
tags: ['kafka', 'docs']
aliases: 
keywords: 
type: docs
---

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->


The essential configurations are the following: 

  * `node.id`
  * `log.dirs`
  * `process.roles`
  * `controller.quorum.bootstrap.servers`
  * `controller.listener.names` 

Broker configurations and defaults are discussed in more detail below. {{< include-html file="/static/{version}/generated/kafka_config.html" >}} 

More details about broker configuration can be found in the scala class `kafka.server.KafkaConfig`.

## Updating Broker Configs

From Kafka version 1.1 onwards, some of the broker configs can be updated without restarting the broker. See the `Dynamic Update Mode` column in Broker Configs for the update mode of each broker config. 

  * `read-only`: Requires a broker restart for update
  * `per-broker`: May be updated dynamically for each broker
  * `cluster-wide`: May be updated dynamically as a cluster-wide default. May also be updated as a per-broker value for testing.

To alter the current broker configs for broker id 0 (for example, the number of log cleaner threads): 
    
    
    $ bin/kafka-configs.sh --bootstrap-server localhost:9092 --entity-type brokers --entity-name 0 --alter --add-config log.cleaner.threads=2

To describe the current dynamic broker configs for broker id 0: 
    
    
    $ bin/kafka-configs.sh --bootstrap-server localhost:9092 --entity-type brokers --entity-name 0 --describe

To delete a config override and revert to the statically configured or default value for broker id 0 (for example, the number of log cleaner threads): 
    
    
    $ bin/kafka-configs.sh --bootstrap-server localhost:9092 --entity-type brokers --entity-name 0 --alter --delete-config log.cleaner.threads

Some configs may be configured as a cluster-wide default to maintain consistent values across the whole cluster. All brokers in the cluster will process the cluster default update. For example, to update log cleaner threads on all brokers: 
    
    
    $ bin/kafka-configs.sh --bootstrap-server localhost:9092 --entity-type brokers --entity-default --alter --add-config log.cleaner.threads=2

To describe the currently configured dynamic cluster-wide default configs: 
    
    
    $ bin/kafka-configs.sh --bootstrap-server localhost:9092 --entity-type brokers --entity-default --describe

All configs that are configurable at cluster level may also be configured at per-broker level (e.g. for testing). If a config value is defined at different levels, the following order of precedence is used: 

  * Dynamic per-broker config stored in the metadata log
  * Dynamic cluster-wide default config stored in the metadata log
  * Static broker config from `server.properties`
  * Kafka default, see broker configs



### Updating SSL Keystore of an Existing Listener

Brokers may be configured with SSL keystores with short validity periods to reduce the risk of compromised certificates. Keystores may be updated dynamically without restarting the broker. The config name must be prefixed with the listener prefix `listener.name.{listenerName}.` so that only the keystore config of a specific listener is updated. The following configs may be updated in a single alter request at per-broker level: 

  * `ssl.keystore.type`
  * `ssl.keystore.location`
  * `ssl.keystore.password`
  * `ssl.key.password`

If the listener is the inter-broker listener, the update is allowed only if the new keystore is trusted by the truststore configured for that listener. For other listeners, no trust validation is performed on the keystore by the broker. Certificates must be signed by the same certificate authority that signed the old certificate to avoid any client authentication failures. 

### Updating SSL Truststore of an Existing Listener

Broker truststores may be updated dynamically without restarting the broker to add or remove certificates. Updated truststore will be used to authenticate new client connections. The config name must be prefixed with the listener prefix `listener.name.{listenerName}.` so that only the truststore config of a specific listener is updated. The following configs may be updated in a single alter request at per-broker level: 

  * `ssl.truststore.type`
  * `ssl.truststore.location`
  * `ssl.truststore.password`

If the listener is the inter-broker listener, the update is allowed only if the existing keystore for that listener is trusted by the new truststore. For other listeners, no trust validation is performed by the broker before the update. Removal of CA certificates used to sign client certificates from the new truststore can lead to client authentication failures. 

### Updating Default Topic Configuration

Default topic configuration options used by brokers may be updated without broker restart. The configs are applied to topics without a topic config override for the equivalent per-topic config. One or more of these configs may be overridden at cluster-default level used by all brokers. 

  * `log.segment.bytes`
  * `log.roll.ms`
  * `log.roll.hours`
  * `log.roll.jitter.ms`
  * `log.roll.jitter.hours`
  * `log.index.size.max.bytes`
  * `log.flush.interval.messages`
  * `log.flush.interval.ms`
  * `log.retention.bytes`
  * `log.retention.ms`
  * `log.retention.minutes`
  * `log.retention.hours`
  * `log.index.interval.bytes`
  * `log.cleaner.delete.retention.ms`
  * `log.cleaner.min.compaction.lag.ms`
  * `log.cleaner.max.compaction.lag.ms`
  * `log.cleaner.min.cleanable.ratio`
  * `log.cleanup.policy`
  * `log.segment.delete.delay.ms`
  * `unclean.leader.election.enable`
  * `min.insync.replicas`
  * `max.message.bytes`
  * `compression.type`
  * `log.preallocate`
  * `log.message.timestamp.type`



### Updating Log Cleaner Configs

Log cleaner configs may be updated dynamically at cluster-default level used by all brokers. The changes take effect on the next iteration of log cleaning. One or more of these configs may be updated: 

  * `log.cleaner.threads`
  * `log.cleaner.io.max.bytes.per.second`
  * `log.cleaner.dedupe.buffer.size`
  * `log.cleaner.io.buffer.size`
  * `log.cleaner.io.buffer.load.factor`
  * `log.cleaner.backoff.ms`



### Updating Thread Configs

The size of various thread pools used by the broker may be updated dynamically at cluster-default level used by all brokers. Updates are restricted to the range `currentSize / 2` to `currentSize * 2` to ensure that config updates are handled gracefully. 

  * `num.network.threads`
  * `num.io.threads`
  * `num.replica.fetchers`
  * `num.recovery.threads.per.data.dir`
  * `log.cleaner.threads`
  * `background.threads`
  * `remote.log.reader.threads`
  * `remote.log.manager.copier.thread.pool.size`
  * `remote.log.manager.expiration.thread.pool.size`
  * `remote.log.manager.follower.thread.pool.size`



### Updating ConnectionQuota Configs

The maximum number of connections allowed for a given IP/host by the broker may be updated dynamically at cluster-default level used by all brokers. The changes will apply for new connection creations and the existing connections count will be taken into account by the new limits. 

  * `max.connections.per.ip`
  * `max.connections.per.ip.overrides`



### Adding and Removing Listeners

Listeners may be added or removed dynamically. When a new listener is added, security configs of the listener must be provided as listener configs with the listener prefix `listener.name.{listenerName}.`. If the new listener uses SASL, the JAAS configuration of the listener must be provided using the JAAS configuration property `sasl.jaas.config` with the listener and mechanism prefix. See JAAS configuration for Kafka brokers for details.

In Kafka version 1.1.x, the listener used by the inter-broker listener may not be updated dynamically. To update the inter-broker listener to a new listener, the new listener may be added on all brokers without restarting the broker. A rolling restart is then required to update `inter.broker.listener.name`.

In addition to all the security configs of new listeners, the following configs may be updated dynamically at per-broker level: 

  * `listeners`
  * `advertised.listeners`
  * `listener.security.protocol.map`

Inter-broker listener must be configured using the static broker configuration `inter.broker.listener.name` or `security.inter.broker.protocol`. 
