/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal;

import com.jediterm.terminal.TerminalDataStream;
import com.jediterm.terminal.util.CharUtils;
import java.io.IOException;

public class ArrayTerminalDataStream
implements TerminalDataStream {
    protected char[] myBuf;
    protected int myOffset;
    protected int myLength;

    public ArrayTerminalDataStream(char[] buf, int offset, int length) {
        this.myBuf = buf;
        this.myOffset = offset;
        this.myLength = length;
    }

    public ArrayTerminalDataStream(char[] buf) {
        this(buf, 0, buf.length);
    }

    @Override
    public char getChar() throws IOException {
        if (this.myLength == 0) {
            throw new TerminalDataStream.EOF();
        }
        --this.myLength;
        return this.myBuf[this.myOffset++];
    }

    @Override
    public void pushChar(char c) throws TerminalDataStream.EOF {
        if (this.myOffset == 0) {
            char[] newBuf = this.myBuf.length - this.myLength == 0 ? new char[this.myBuf.length + 1] : this.myBuf;
            this.myOffset = newBuf.length - this.myLength;
            System.arraycopy(this.myBuf, 0, newBuf, this.myOffset, this.myLength);
            this.myBuf = newBuf;
        }
        ++this.myLength;
        this.myBuf[--this.myOffset] = c;
    }

    @Override
    public String readNonControlCharacters(int maxChars) throws IOException {
        String nonControlCharacters = CharUtils.getNonControlCharacters(maxChars, this.myBuf, this.myOffset, this.myLength);
        this.myOffset += nonControlCharacters.length();
        this.myLength -= nonControlCharacters.length();
        return nonControlCharacters;
    }

    @Override
    public void pushBackBuffer(char[] chars, int length) {
        if (this.myLength + length > this.myBuf.length) {
            char[] newBuf = new char[this.myLength + length];
            System.arraycopy(this.myBuf, this.myOffset, newBuf, newBuf.length - this.myLength, this.myLength);
            this.myOffset = newBuf.length - this.myLength;
            this.myBuf = newBuf;
        } else if (this.myOffset < length) {
            System.arraycopy(this.myBuf, this.myOffset, this.myBuf, length, this.myLength);
            this.myOffset = length;
        }
        System.arraycopy(chars, 0, this.myBuf, this.myOffset - length, length);
        this.myOffset -= length;
        this.myLength += length;
    }

    @Override
    public boolean isEmpty() {
        return this.myLength == 0;
    }
}

