/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.restructuredtext.python.inspections;

import com.google.common.collect.ImmutableSet;
import com.intellij.codeInspection.AddToInspectionOptionListFix;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.options.OptPane;
import com.intellij.codeInspection.options.OptRegularComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.restructuredtext.RestBundle;
import com.intellij.restructuredtext.RestFile;
import com.intellij.restructuredtext.RestTokenTypes;
import com.intellij.restructuredtext.RestUtil;
import com.intellij.restructuredtext.inspections.RestInspection;
import com.intellij.restructuredtext.inspections.RestInspectionVisitor;
import com.intellij.restructuredtext.psi.RestDirectiveBlock;
import com.intellij.restructuredtext.psi.RestRole;
import com.intellij.restructuredtext.python.PythonRestBundle;
import com.jetbrains.python.ReSTService;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class RestRoleInspection
extends RestInspection {
    public JDOMExternalizableStringList ignoredRoles = new JDOMExternalizableStringList();

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            RestRoleInspection.$$$reportNull$$$0(0);
        }
        return new Visitor(holder, (List<String>)this.ignoredRoles);
    }

    @NotNull
    public OptPane getOptionsPane() {
        OptPane optPane = OptPane.pane((OptRegularComponent[])new OptRegularComponent[]{OptPane.stringList((String)"ignoredRoles", (String)PythonRestBundle.message("python.rest.inspections.role.ignore.roles.label", new Object[0]))});
        if (optPane == null) {
            RestRoleInspection.$$$reportNull$$$0(1);
        }
        return optPane;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/restructuredtext/python/inspections/RestRoleInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/restructuredtext/python/inspections/RestRoleInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptionsPane";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 1: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private class Visitor
    extends RestInspectionVisitor {
        private final ImmutableSet<String> myIgnoredRoles;
        Set<String> mySphinxRoles;

        Visitor(ProblemsHolder holder, List<String> ignoredRoles) {
            super(holder);
            this.mySphinxRoles = new HashSet<String>();
            this.myIgnoredRoles = ImmutableSet.copyOf(ignoredRoles);
            Project project = holder.getProject();
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)holder.getFile());
            if (module == null) {
                return;
            }
            String dir = ReSTService.getInstance((Module)module).getWorkdir();
            if (!dir.isEmpty()) {
                this.fillSphinxRoles(dir, project);
            }
        }

        private void fillSphinxRoles(String dir, Project project) {
            VirtualFile config = LocalFileSystem.getInstance().findFileByPath((String)(dir.endsWith("/") ? dir : dir + "/") + "conf.py");
            if (config == null) {
                return;
            }
            PsiFile configFile = PsiManager.getInstance((Project)project).findFile(config);
            if (configFile instanceof PyFile) {
                PyFile file = (PyFile)configFile;
                List functions = file.getTopLevelFunctions();
                for (PyFunction function : functions) {
                    PyStatement[] statements;
                    if (!"setup".equals(function.getName())) continue;
                    PyStatementList stList = function.getStatementList();
                    for (PyStatement statement : statements = stList.getStatements()) {
                        PyExpression arg;
                        if (statement instanceof PyExpressionStatement) {
                            statement = ((PyExpressionStatement)statement).getExpression();
                        }
                        if (!(statement instanceof PyCallExpression) || !((PyCallExpression)statement).isCalleeText(new String[]{"add_role"}) || !((arg = ((PyCallExpression)statement).getArguments()[0]) instanceof PyStringLiteralExpression)) continue;
                        this.mySphinxRoles.add(((PyStringLiteralExpression)arg).getStringValue());
                    }
                }
            }
        }

        public void visitRole(RestRole node) {
            RestFile file = (RestFile)node.getContainingFile();
            if (PsiTreeUtil.getParentOfType((PsiElement)node, RestDirectiveBlock.class) != null) {
                return;
            }
            PsiElement sibling = node.getNextSibling();
            if (sibling == null || sibling.getNode().getElementType() != RestTokenTypes.INTERPRETED) {
                return;
            }
            if (RestUtil.PREDEFINED_ROLES.contains(node.getText()) || this.myIgnoredRoles.contains((Object)node.getRoleName())) {
                return;
            }
            if (RestUtil.SPHINX_ROLES.contains(node.getText()) || RestUtil.SPHINX_ROLES.contains(":py" + node.getText()) || this.mySphinxRoles.contains(node.getRoleName())) {
                return;
            }
            HashSet<String> definedRoles = new HashSet<String>();
            RestDirectiveBlock[] directives = (RestDirectiveBlock[])PsiTreeUtil.getChildrenOfType((PsiElement)file, RestDirectiveBlock.class);
            if (directives != null) {
                for (RestDirectiveBlock block : directives) {
                    PsiElement role;
                    if (!block.getDirectiveName().equals("role::") || (role = block.getFirstChild().getNextSibling()) == null) continue;
                    String roleName = role.getText().trim();
                    int index = roleName.indexOf(40);
                    if (index != -1) {
                        roleName = roleName.substring(0, index);
                    }
                    definedRoles.add(roleName);
                }
            }
            if (definedRoles.contains(node.getRoleName())) {
                return;
            }
            this.registerProblem((PsiElement)node, PythonRestBundle.message("python.rest.inspection.message.not.defined.role", node.getRoleName()), (LocalQuickFix)new AddToInspectionOptionListFix((InspectionProfileEntry)RestRoleInspection.this, RestBundle.message((String)"QFIX.ignore.role.0", (Object[])new Object[]{node.getRoleName()}), node.getRoleName(), inspection -> inspection.ignoredRoles));
        }
    }
}

