/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.csv.CsvFormatsSettings;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.extensions.ExtensionScriptsUtil;
import com.intellij.database.extensions.ExtractorScripts;
import com.intellij.database.extractors.BaseExtractorConfig;
import com.intellij.database.extractors.DataAggregatorFactory;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.ExtractorConfig;
import com.intellij.database.extractors.ExtractorsHelper;
import com.intellij.database.extractors.NoDbScriptDataExtractor;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.XlsxExtractorFactory;
import com.intellij.ide.script.IdeScriptEngine;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseExtractorsHelper
implements ExtractorsHelper {
    public static final BaseExtractorsHelper INSTANCE = new BaseExtractorsHelper();

    protected BaseExtractorsHelper() {
    }

    @Override
    public boolean isApplicable(@Nullable CoreGrid<GridRow, GridColumn> grid) {
        return true;
    }

    @Override
    @NotNull
    public DataExtractorFactory createScriptExtractorFactory(@NotNull String scriptFileName, @Nullable BiConsumer<String, Project> installPlugin) {
        if (scriptFileName == null) {
            BaseExtractorsHelper.$$$reportNull$$$0(0);
        }
        return new Script(scriptFileName, installPlugin);
    }

    @Override
    @NotNull
    public DataAggregatorFactory createScriptAggregatorFactory(@NotNull String scriptFileName, @Nullable BiConsumer<String, Project> installPlugin) {
        if (scriptFileName == null) {
            BaseExtractorsHelper.$$$reportNull$$$0(1);
        }
        return new Script(scriptFileName, installPlugin);
    }

    @Override
    public DataExtractorFactory getDefaultExtractorFactory(@NotNull CoreGrid<GridRow, GridColumn> grid, @Nullable BiConsumer<String, Project> installPlugin, @Nullable CsvFormatsSettings settings) {
        if (grid == null) {
            BaseExtractorsHelper.$$$reportNull$$$0(2);
        }
        return null;
    }

    @Override
    @NotNull
    public ExtractorConfig createExtractorConfig(@NotNull CoreGrid<GridRow, GridColumn> grid, @NotNull ObjectFormatter formatter) {
        if (grid == null) {
            BaseExtractorsHelper.$$$reportNull$$$0(3);
        }
        if (formatter == null) {
            BaseExtractorsHelper.$$$reportNull$$$0(4);
        }
        return new BaseExtractorConfig(formatter, grid.getProject());
    }

    @Override
    @NotNull
    public List<DataExtractorFactory> getBuiltInFactories() {
        List<DataExtractorFactory> list = List.of(new XlsxExtractorFactory());
        if (list == null) {
            BaseExtractorsHelper.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptFileName";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "formatter";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/BaseExtractorsHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/BaseExtractorsHelper";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltInFactories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createScriptExtractorFactory";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createScriptAggregatorFactory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultExtractorFactory";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createExtractorConfig";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    public static class Script
    implements DataExtractorFactory,
    DataAggregatorFactory {
        protected final String myScriptFileName;
        protected final BiConsumer<String, Project> myInstallPlugin;
        private final String mySimpleName;

        public Script(@NotNull String scriptFileName, @Nullable BiConsumer<String, Project> installPlugin) {
            if (scriptFileName == null) {
                Script.$$$reportNull$$$0(0);
            }
            this.myScriptFileName = scriptFileName;
            this.myInstallPlugin = installPlugin;
            this.mySimpleName = Script.extractSimpleName(this.myScriptFileName);
        }

        @NlsSafe
        @NotNull
        public static String extractSimpleName(String fileName) {
            String mySimpleName;
            int dot = fileName.indexOf(46);
            String simpleName = dot == -1 ? fileName : fileName.substring(0, dot);
            int dash = simpleName.lastIndexOf(45);
            String lastPart = dash == -1 || dash == simpleName.length() - 1 ? "" : simpleName.substring(dash + 1);
            String string = mySimpleName = StringUtil.equalsIgnoreCase((CharSequence)lastPart, (CharSequence)"groovy") || StringUtil.equalsIgnoreCase((CharSequence)lastPart, (CharSequence)"javascript") ? simpleName.substring(0, dash) : simpleName;
            if (string == null) {
                Script.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NlsSafe
        @NotNull
        public String getName() {
            String string = this.myScriptFileName;
            if (string == null) {
                Script.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        public boolean supportsText() {
            return true;
        }

        @NotNull
        public String getScriptFileName() {
            String string = this.myScriptFileName;
            if (string == null) {
                Script.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        @NlsSafe
        @NotNull
        public String getSimpleName() {
            String string = this.mySimpleName;
            if (string == null) {
                Script.$$$reportNull$$$0(4);
            }
            return string;
        }

        @Override
        @NotNull
        public String getFileExtension() {
            String string = ExtractorScripts.getOutputFileExtension(this.myScriptFileName);
            if (string == null) {
                Script.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        @Nullable
        public DataExtractor createExtractor(@NotNull ExtractorConfig config) {
            Path script;
            if (config == null) {
                Script.$$$reportNull$$$0(6);
            }
            if ((script = ExtractorScripts.findExtractorScript(this.myScriptFileName)) == null) {
                return null;
            }
            ExtensionScriptsUtil.prepareScript(script);
            IdeScriptEngine engine = ExtensionScriptsUtil.getEngineFor(config.getProject(), ExtractorScripts.getPluginId(), script, this.myInstallPlugin);
            return engine == null ? null : new NoDbScriptDataExtractor(config.getProject(), script, engine, config.getObjectFormatter(), false, true);
        }

        @Override
        @Nullable
        public DataExtractor createAggregator(@NotNull ExtractorConfig config) {
            Path script;
            if (config == null) {
                Script.$$$reportNull$$$0(7);
            }
            if ((script = ExtractorScripts.findAggregatorScript(this.myScriptFileName)) == null) {
                return null;
            }
            ExtensionScriptsUtil.prepareScript(script);
            IdeScriptEngine engine = ExtensionScriptsUtil.getEngineFor(config.getProject(), ExtractorScripts.getPluginId(), script, null, false);
            return engine == null ? null : new NoDbScriptDataExtractor(config.getProject(), script, engine, config.getObjectFormatter(), true, true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "scriptFileName";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/extractors/BaseExtractorsHelper$Script";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/extractors/BaseExtractorsHelper$Script";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "extractSimpleName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getScriptFileName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSimpleName";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileExtension";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "createExtractor";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "createAggregator";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

