/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.grammar.spi;

import java.awt.Component;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.Icon;
import org.apache.maven.project.MavenProject;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.filter.ElementFilter;
import org.jdom2.filter.Filter;
import org.jdom2.input.SAXBuilder;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.xml.api.model.GrammarEnvironment;
import org.netbeans.modules.xml.api.model.GrammarQuery;
import org.netbeans.modules.xml.api.model.GrammarResult;
import org.netbeans.modules.xml.api.model.HintContext;
import org.netbeans.modules.xml.spi.dom.AbstractNode;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Enumerations;
import org.openide.util.ImageUtilities;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class AbstractSchemaBasedGrammar
implements GrammarQuery {
    Document schemaDoc;
    private GrammarEnvironment environment;

    public AbstractSchemaBasedGrammar(GrammarEnvironment env) {
        this.environment = env;
        try {
            SAXBuilder builder = new SAXBuilder();
            InputStream stream = this.getSchemaStream();
            this.schemaDoc = builder.build(stream);
        }
        catch (Exception exc) {
            ErrorManager.getDefault().notify((Throwable)exc);
        }
    }

    protected final GrammarEnvironment getEnvironment() {
        return this.environment;
    }

    protected final MavenProject getMavenProject() {
        Project proj = FileOwnerQuery.getOwner((FileObject)this.environment.getFileObject());
        if (proj != null) {
            NbMavenProject watch = (NbMavenProject)proj.getLookup().lookup(NbMavenProject.class);
            assert (watch != null);
            return watch.getMavenProject();
        }
        ErrorManager.getDefault().log(16, "File " + this.environment.getFileObject() + " has maven2 code completion but doesn't belong to a maven2 project.");
        return null;
    }

    protected abstract InputStream getSchemaStream();

    protected List<GrammarResult> getDynamicCompletion(String path, HintContext hintCtx, org.jdom2.Element lowestParent) {
        return Collections.emptyList();
    }

    protected Enumeration<GrammarResult> getDynamicValueCompletion(String path, HintContext virtualTextCtx, org.jdom2.Element el) {
        return null;
    }

    protected final org.jdom2.Element findElement(org.jdom2.Element parent, String name) {
        List childs = parent.getChildren("element", parent.getNamespace());
        for (org.jdom2.Element el : childs) {
            if (!name.equals(el.getAttributeValue("name"))) continue;
            return el;
        }
        return null;
    }

    protected final org.jdom2.Element findNonTypedContent(org.jdom2.Element root) {
        org.jdom2.Element complex = root.getChild("complexType", root.getNamespace());
        if (complex != null) {
            complex = complex.getChild("sequence", root.getNamespace());
        }
        return complex;
    }

    protected final org.jdom2.Element findTypeContent(String type, org.jdom2.Element docRoot) {
        List lst = docRoot.getContent();
        for (Content c : lst) {
            org.jdom2.Element el;
            if (!(c instanceof org.jdom2.Element) || !"complexType".equals((el = (org.jdom2.Element)c).getName()) || !type.equals(el.getAttributeValue("name"))) continue;
            return el.getChild("all", docRoot.getNamespace());
        }
        return null;
    }

    private void processElement(String matches, org.jdom2.Element childEl, Vector<GrammarResult> suggestions) {
        String childRefAttr = childEl.getAttributeValue("ref");
        if (childRefAttr == null) {
            childRefAttr = childEl.getAttributeValue("name");
        }
        if (childRefAttr != null && childRefAttr.startsWith(matches)) {
            suggestions.add(new MyElement(childRefAttr));
        }
    }

    public Component getCustomizer(HintContext nodeCtx) {
        return null;
    }

    public Node.Property[] getProperties(HintContext nodeCtx) {
        return new Node.Property[0];
    }

    public boolean hasCustomizer(HintContext nodeCtx) {
        return false;
    }

    public boolean isAllowed(Enumeration en) {
        return true;
    }

    protected final void processSequence(String matches, org.jdom2.Element seqEl, Vector<GrammarResult> suggestions) {
        List availables = seqEl.getContent((Filter)new ElementFilter());
        for (org.jdom2.Element childEl : availables) {
            if (!"element".equals(childEl.getName()) && !"group".equals(childEl.getName())) continue;
            this.processElement(matches, childEl, suggestions);
        }
    }

    public Enumeration<GrammarResult> queryAttributes(HintContext ownerElementCtx) {
        return Enumerations.empty();
    }

    public GrammarResult queryDefault(HintContext parentNodeCtx) {
        return null;
    }

    public Enumeration<GrammarResult> queryElements(HintContext virtualElementCtx) {
        String start = virtualElementCtx.getCurrentPrefix();
        Node parentNode = virtualElementCtx.getParentNode();
        boolean hasSchema = false;
        if (parentNode != null && this.schemaDoc != null) {
            ArrayList<String> parentNames = new ArrayList<String>();
            while (parentNode != null & parentNode.getNodeName() != null) {
                parentNames.add(0, parentNode.getNodeName());
                if (parentNode.getParentNode() == null || parentNode.getParentNode().getNodeName() == null) {
                    NamedNodeMap nnm = parentNode.getAttributes();
                    hasSchema = nnm.getNamedItemNS("xsi", "schemaLocation") != null;
                }
                parentNode = parentNode.getParentNode();
            }
            org.jdom2.Element schemaParent = this.schemaDoc.getRootElement();
            Iterator it = parentNames.iterator();
            String path = "";
            Vector<GrammarResult> toReturn = new Vector<GrammarResult>();
            while (it.hasNext() && schemaParent != null) {
                String str = (String)it.next();
                path = path + "/" + str;
                org.jdom2.Element el = this.findElement(schemaParent, str);
                if (!it.hasNext()) {
                    toReturn.addAll(this.getDynamicCompletion(path, virtualElementCtx, el));
                }
                if (el == null) continue;
                String type = el.getAttributeValue("type");
                if (type != null) {
                    schemaParent = this.findTypeContent(type, this.schemaDoc.getRootElement());
                    if (schemaParent != null) continue;
                    System.err.println("no schema parent for " + str + " of type " + el.getAttributeValue("type"));
                    continue;
                }
                schemaParent = this.findNonTypedContent(el);
            }
            if (schemaParent != null && !hasSchema) {
                this.processSequence(start, schemaParent, toReturn);
            }
            return toReturn.elements();
        }
        return Enumerations.empty();
    }

    public Enumeration<GrammarResult> queryEntities(String prefix) {
        return Enumerations.empty();
    }

    public Enumeration<GrammarResult> queryNotations(String prefix) {
        return Enumerations.empty();
    }

    public Enumeration<GrammarResult> queryValues(HintContext virtualTextCtx) {
        Node parentNode = virtualTextCtx.getParentNode();
        ArrayList<String> parentNames = new ArrayList<String>();
        if (virtualTextCtx.getCurrentPrefix().length() == 0) {
            parentNames.add(virtualTextCtx.getNodeName());
        }
        if (parentNode != null && this.schemaDoc != null) {
            while (parentNode != null & parentNode.getNodeName() != null) {
                parentNames.add(0, parentNode.getNodeName());
                parentNode = parentNode.getParentNode();
            }
            org.jdom2.Element schemaParent = this.schemaDoc.getRootElement();
            Iterator it = parentNames.iterator();
            String path = "";
            while (it.hasNext() && schemaParent != null) {
                Enumeration<GrammarResult> en;
                String str = (String)it.next();
                path = path + "/" + str;
                org.jdom2.Element el = this.findElement(schemaParent, str);
                if (!it.hasNext() && (en = this.getDynamicValueCompletion(path, virtualTextCtx, el)) != null) {
                    return en;
                }
                if (el == null) continue;
                String type = el.getAttributeValue("type");
                if (type != null) {
                    schemaParent = this.findTypeContent(type, this.schemaDoc.getRootElement());
                    if (schemaParent != null) continue;
                    System.err.println("no schema parent for " + str + " of type=" + el.getAttributeValue("type"));
                    continue;
                }
                schemaParent = this.findNonTypedContent(el);
            }
        }
        return Enumerations.empty();
    }

    protected final Enumeration<GrammarResult> createTextValueList(String[] values, HintContext context) {
        ArrayList<MyTextElement> elems = new ArrayList<MyTextElement>();
        for (String value : values) {
            if (!value.startsWith(context.getCurrentPrefix())) continue;
            elems.add(new MyTextElement(value, context.getCurrentPrefix()));
        }
        return Collections.enumeration(elems);
    }

    public static class MyElement
    extends AbstractResultNode
    implements Element {
        private String name;

        public MyElement(String name) {
            this.name = name;
            this.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/grammar/element.png", (boolean)false));
        }

        @Override
        public short getNodeType() {
            return 1;
        }

        @Override
        public String getNodeName() {
            return this.name;
        }

        @Override
        public String getTagName() {
            return this.name;
        }
    }

    public static class MyTextElement
    extends AbstractResultNode
    implements Text {
        protected final String name;
        protected final String prefix;

        public MyTextElement(String name, String prefix) {
            this.name = name;
            this.prefix = prefix;
            this.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/grammar/value.png", (boolean)false));
        }

        @Override
        public short getNodeType() {
            return 3;
        }

        @Override
        public String getNodeName() {
            return this.name;
        }

        public String getTagName() {
            return this.name;
        }

        @Override
        public String getNodeValue() {
            return this.name.substring(this.prefix.length());
        }
    }

    protected static class ComplexElement
    extends AbstractResultNode
    implements Element {
        private String name;
        private String display;
        private NodeList list;

        ComplexElement(String tagName, String displayName, NodeList listimpl) {
            this.name = tagName;
            this.display = displayName;
            this.list = listimpl;
        }

        @Override
        public short getNodeType() {
            return 1;
        }

        @Override
        public String getNodeName() {
            return this.name;
        }

        @Override
        public String getTagName() {
            return this.name;
        }

        @Override
        public String getDisplayName() {
            return this.display;
        }

        @Override
        public NodeList getChildNodes() {
            return this.list;
        }

        @Override
        public boolean hasChildNodes() {
            return true;
        }

        @Override
        public Node getLastChild() {
            return this.list.item(this.list.getLength() - 1);
        }

        @Override
        public Node getFirstChild() {
            return this.list.item(0);
        }
    }

    protected static class ExpressionValueTextElement
    extends MyTextElement {
        private final int delLen;
        private final String suffix;

        public ExpressionValueTextElement(String pr, String propPrefix, String suffix) {
            super(pr, propPrefix);
            this.suffix = suffix;
            this.delLen = -1;
        }

        public ExpressionValueTextElement(String pr, String propPrefix, int delL) {
            super(pr, propPrefix);
            this.suffix = null;
            this.delLen = delL;
        }

        @Override
        public String getNodeValue() {
            String end = this.name.substring(this.prefix.length()) + "}";
            if (this.suffix == null) {
                return end;
            }
            String suff = this.suffix;
            if (suff.indexOf("}") < suff.indexOf("{")) {
                suff = suff.substring(suff.indexOf("}") + 1);
            }
            return suff;
        }

        @Override
        public int getLength() {
            return this.delLen == -1 ? super.getLength() : this.delLen;
        }
    }

    public static class PartialTextElement
    extends AbstractResultNode
    implements Text {
        public PartialTextElement() {
            this.setIcon(ImageUtilities.loadImageIcon((String)"org/netbeans/modules/maven/navigator/wait.gif", (boolean)false));
        }

        @Override
        public short getNodeType() {
            return 3;
        }

        @Override
        public String getNodeName() {
            return "Incomplete result, still processing indices...";
        }

        public String getTagName() {
            return "Partial result";
        }

        @Override
        public String getNodeValue() {
            return "";
        }
    }

    protected static abstract class AbstractResultNode
    extends AbstractNode
    implements GrammarResult {
        private String desc;
        private Icon icon;

        protected AbstractResultNode() {
        }

        public Icon getIcon(int kind) {
            return this.icon;
        }

        public void setIcon(Icon icon) {
            this.icon = icon;
        }

        public String getDescription() {
            return this.desc;
        }

        public void setDescription(String desc) {
            this.desc = desc;
        }

        public String getText() {
            return this.getNodeName();
        }

        public String getDisplayName() {
            return this.getNodeName();
        }

        public boolean isEmptyElement() {
            return false;
        }

        public String toString() {
            return this.getDisplayName();
        }
    }
}

