/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.fish.payara.micro.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.fish.payara.micro.project.MicroApplication;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.api.customizer.support.ComboBoxUpdater;
import org.netbeans.modules.payara.tooling.data.PayaraPlatformVersion;
import org.netbeans.modules.payara.tooling.data.PayaraPlatformVersionAPI;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class MicroPropertiesPanel
extends JPanel {
    private final Preferences pref;
    private final ComboBoxUpdater<PayaraPlatformVersionAPI> microVersionComboBoxUpdater;
    private PayaraPlatformVersionAPI selectedPayaraVersion;
    private JCheckBox hotDeployCheckBox;
    private JLabel hotDeployLabel;
    private JComboBox microVersionCombobox;
    private JLabel microVersionLabel;

    public MicroPropertiesPanel(ModelHandle2 handle, Project project) {
        this.pref = ProjectUtils.getPreferences((Project)project, MicroApplication.class, (boolean)true);
        this.initComponents();
        String microVersionText = this.pref.get("version", "");
        final PayaraPlatformVersionAPI microVersion = PayaraPlatformVersion.toValue((String)microVersionText);
        this.microVersionComboBoxUpdater = new ComboBoxUpdater<PayaraPlatformVersionAPI>(this, this.microVersionCombobox, this.microVersionLabel){
            final /* synthetic */ MicroPropertiesPanel this$0;
            {
                this.this$0 = this$0;
                super(comp, label);
            }

            public PayaraPlatformVersionAPI getValue() {
                return microVersion != null ? microVersion : PayaraPlatformVersion.EMPTY;
            }

            public PayaraPlatformVersionAPI getDefaultValue() {
                return null;
            }

            public void setValue(PayaraPlatformVersionAPI microVersion2) {
                this.this$0.selectedPayaraVersion = microVersion2;
            }
        };
        this.hotDeployCheckBox.setSelected(this.pref.getBoolean("hotDeploy", false));
    }

    private PayaraPlatformVersionAPI[] getPayaraVersion() {
        ArrayList<PayaraPlatformVersionAPI> microVersions = new ArrayList<PayaraPlatformVersionAPI>();
        microVersions.add(PayaraPlatformVersion.EMPTY);
        microVersions.addAll(PayaraPlatformVersion.getVersions().stream().sorted(Collections.reverseOrder()).collect(Collectors.toList()));
        return microVersions.toArray(new PayaraPlatformVersionAPI[0]);
    }

    private void initComponents() {
        this.microVersionLabel = new JLabel();
        this.microVersionCombobox = new JComboBox();
        this.hotDeployLabel = new JLabel();
        this.hotDeployCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((JLabel)this.microVersionLabel, (String)NbBundle.getMessage(MicroPropertiesPanel.class, (String)"MicroPropertiesPanel.microVersionLabel.text"));
        this.microVersionCombobox.setModel(new DefaultComboBoxModel<PayaraPlatformVersionAPI>(this.getPayaraVersion()));
        Mnemonics.setLocalizedText((JLabel)this.hotDeployLabel, (String)NbBundle.getMessage(MicroPropertiesPanel.class, (String)"MicroPropertiesPanel.hotDeployLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.hotDeployCheckBox, (String)NbBundle.getMessage(MicroPropertiesPanel.class, (String)"MicroPropertiesPanel.hotDeployCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.microVersionLabel).addComponent(this.hotDeployLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.hotDeployCheckBox).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.microVersionCombobox, 0, 272, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.microVersionCombobox, -2, -1, -2).addComponent(this.microVersionLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.hotDeployLabel).addComponent(this.hotDeployCheckBox)).addContainerGap(85, Short.MAX_VALUE)));
    }

    public void applyChanges() {
        this.pref.put("version", this.selectedPayaraVersion != null ? this.selectedPayaraVersion.toString() : "");
        this.pref.put("hotDeploy", Boolean.toString(this.hotDeployCheckBox.isSelected()));
    }
}

