/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.visual.breakpoints;

import com.sun.jdi.ObjectReference;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.LineBreakpoint;
import org.netbeans.modules.debugger.jpda.visual.spi.ComponentInfo;

public abstract class ComponentBreakpoint
extends Breakpoint {
    public static final int TYPE_ADD = 1;
    public static final int TYPE_REMOVE = 2;
    public static final int TYPE_SHOW = 4;
    public static final int TYPE_HIDE = 8;
    public static final int TYPE_REPAINT = 16;
    public static final String PROP_TYPE = "type";
    private ComponentDescription component;
    private int type = 15;
    private boolean enabled = true;
    private String condition = "";
    private int suspend;
    private String printText;

    public ComponentBreakpoint(ComponentDescription component) {
        this.component = component;
        this.suspend = LineBreakpoint.create((String)"", (int)0).getSuspend();
    }

    public ComponentDescription getComponent() {
        return this.component;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        int oldType = this.type;
        this.type = type;
        this.firePropertyChange(PROP_TYPE, oldType, type);
    }

    public abstract int supportedTypes();

    public boolean isEnabled() {
        return this.enabled;
    }

    public void enable() {
        if (this.enabled) {
            return;
        }
        this.enabled = true;
        this.firePropertyChange("enabled", Boolean.FALSE, Boolean.TRUE);
    }

    public void disable() {
        if (!this.enabled) {
            return;
        }
        this.enabled = false;
        this.firePropertyChange("enabled", Boolean.TRUE, Boolean.FALSE);
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setSuspend(int suspend) {
        int oldSuspend;
        ComponentBreakpoint componentBreakpoint = this;
        synchronized (componentBreakpoint) {
            oldSuspend = this.suspend;
            if (suspend == oldSuspend) {
                return;
            }
            this.suspend = suspend;
        }
        this.firePropertyChange("suspend", oldSuspend, suspend);
    }

    int getSuspend() {
        return this.suspend;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPrintText(String printText) {
        String old;
        ComponentBreakpoint componentBreakpoint = this;
        synchronized (componentBreakpoint) {
            if (Objects.equals(printText, this.printText)) {
                return;
            }
            old = this.printText;
            this.printText = printText;
        }
        this.firePropertyChange("printText", old, printText);
    }

    public static class ComponentDescription {
        private Map<JPDADebugger, ObjectReference> components = new WeakHashMap<JPDADebugger, ObjectReference>();
        private ComponentInfo ci;

        public ComponentDescription(ComponentInfo ci, JPDADebugger debugger, ObjectReference component) {
            this.ci = ci;
            this.components.put(debugger, component);
        }

        public ComponentDescription(String definition) {
        }

        public ComponentInfo getComponentInfo() {
            return this.ci;
        }

        public ObjectReference getComponent(JPDADebugger debugger) {
            return this.components.get(debugger);
        }
    }
}

