/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ddloaders;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.ref.WeakReference;
import java.util.Date;
import javax.swing.SwingUtilities;
import org.netbeans.modules.j2ee.sun.dd.api.CommonDDBean;
import org.netbeans.modules.j2ee.sun.dd.api.RootInterface;
import org.netbeans.modules.j2ee.sun.dd.impl.common.DDProviderDataObject;
import org.netbeans.modules.j2ee.sun.ddloaders.api.Transaction;
import org.netbeans.modules.j2ee.sun.ddloaders.api.TransactionSupport;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataSynchronizer;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.NbBundle;

public abstract class DDMultiViewDataObject
extends XmlMultiViewDataObject
implements DDProviderDataObject,
TransactionSupport {
    private WeakReference transactionReference = null;
    private static final int HANDLE_UNPARSABLE_TIMEOUT = 2000;
    private ModelSynchronizer modelSynchronizer = new ModelSynchronizer(this);

    public DDMultiViewDataObject(FileObject pf, MultiFileLoader loader) throws DataObjectExistsException {
        super(pf, loader);
    }

    public void modelUpdatedFromUI() {
        this.modelSynchronizer.requestUpdateData();
    }

    public XmlMultiViewDataSynchronizer getModelSynchronizer() {
        return this.modelSynchronizer;
    }

    public void checkParseable() {
        if (!this.isDocumentParseable()) {
            NotifyDescriptor.Message desc = new NotifyDescriptor.Message((Object)NbBundle.getMessage(DDMultiViewDataObject.class, (String)"TXT_DocumentUnparsable", (Object)this.getPrimaryFile().getNameExt()), 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DDMultiViewDataObject.this.goToXmlView();
                }
            });
        }
    }

    public InputStream createInputStream() {
        return this.getDataCache().createInputStream();
    }

    public Reader createReader() throws IOException {
        return this.getDataCache().createReader();
    }

    public void writeModel(RootInterface model) throws IOException {
        if (this.transactionReference != null && this.transactionReference.get() != null) {
            return;
        }
        FileLock dataLock = this.waitForLock();
        if (dataLock == null) {
            return;
        }
        try {
            if (((ModelSynchronizer)this.getModelSynchronizer()).mayUpdateData(true)) {
                this.writeModel(model, dataLock);
            }
        }
        finally {
            dataLock.releaseLock();
        }
    }

    public void writeModel(RootInterface model, FileLock dataLock) {
        ModelSynchronizer synchronizer = (ModelSynchronizer)this.getModelSynchronizer();
        this.modelSynchronizer.getReloadTask().cancel();
        ((RootInterface)synchronizer.getModel()).merge((CommonDDBean)model, 3);
        synchronizer.updateData(dataLock, false);
    }

    public FileLock getDataLock() {
        try {
            return this.getModelSynchronizer().takeLock();
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
    }

    protected abstract boolean isModelCreated();

    protected abstract void parseDocument() throws IOException;

    protected abstract void validateDocument() throws IOException;

    protected String generateDocumentFromModel(RootInterface model) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            model.write((OutputStream)out);
            out.close();
            return out.toString("UTF8");
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        catch (IllegalStateException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return out.toString();
    }

    protected abstract RootInterface getDDModel();

    protected abstract boolean isDocumentParseable();

    @Override
    public Transaction openTransaction() {
        final XmlMultiViewDataSynchronizer.Transaction synchronizerTransaction = this.getModelSynchronizer().openTransaction();
        if (synchronizerTransaction == null) {
            return null;
        }
        Transaction transaction = new Transaction(){
            final /* synthetic */ DDMultiViewDataObject this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void rollback() {
                synchronizerTransaction.rollback();
                this.this$0.transactionReference = null;
            }

            @Override
            public void commit() throws IOException {
                synchronizerTransaction.commit();
                this.this$0.transactionReference = null;
            }
        };
        this.transactionReference = new WeakReference<2>(transaction);
        return transaction;
    }

    public void notifyError(Exception ex) {
        NotifyDescriptor.Message ndd = new NotifyDescriptor.Message((Object)ex.getMessage(), 0);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)ndd);
    }

    private class ModelSynchronizer
    extends XmlMultiViewDataSynchronizer {
        private long handleUnparseableTimeout;
        private Boolean overwriteUnparseable;

        public ModelSynchronizer(XmlMultiViewDataObject dataObject) {
            super(dataObject, 300);
            this.handleUnparseableTimeout = 0L;
            this.overwriteUnparseable = Boolean.TRUE;
            this.handleUnparseableTimeout = 0L;
            this.overwriteUnparseable = Boolean.TRUE;
        }

        protected boolean mayUpdateData(boolean allowDialog) {
            long time;
            if (DDMultiViewDataObject.this.isDocumentParseable()) {
                return true;
            }
            if (!allowDialog) {
                return false;
            }
            if (this.handleUnparseableTimeout != -1L && (time = new Date().getTime()) > this.handleUnparseableTimeout) {
                this.handleUnparseableTimeout = -1L;
                Utils.runInAwtDispatchThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        String message = NbBundle.getMessage(XmlMultiViewDataObject.class, (String)"TXT_OverwriteUnparsableDocument", (Object)DDMultiViewDataObject.this.getPrimaryFile().getNameExt());
                        NotifyDescriptor.Confirmation desc = new NotifyDescriptor.Confirmation((Object)message, 0, 2);
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)desc);
                        ModelSynchronizer.this.overwriteUnparseable = desc.getValue() == NotifyDescriptor.YES_OPTION;
                        ModelSynchronizer.this.handleUnparseableTimeout = new Date().getTime() + 2000L;
                    }
                });
            }
            return this.overwriteUnparseable;
        }

        public void updateData(FileLock dataLock, boolean modify) {
            super.updateData(dataLock, modify);
            try {
                DDMultiViewDataObject.this.validateDocument();
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(4096, (Throwable)e);
            }
        }

        protected void updateDataFromModel(Object model, FileLock lock, boolean modify) {
            String newDocument = DDMultiViewDataObject.this.generateDocumentFromModel((RootInterface)model);
            try {
                DDMultiViewDataObject.this.getDataCache().setData(lock, newDocument, modify);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }

        protected Object getModel() {
            return DDMultiViewDataObject.this.getDDModel();
        }

        protected void reloadModelFromData() {
            try {
                DDMultiViewDataObject.this.parseDocument();
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }
}

