/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.context;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.CharTokenizer;
import org.apache.maven.index.creator.JarFileContentsIndexCreator;

public final class NexusAnalyzer
extends AnalyzerWrapper {
    private static final Analyzer CLASS_NAMES_ANALYZER = new Analyzer(){

        protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
            DeprecatedClassnamesTokenizer tokenizer = new DeprecatedClassnamesTokenizer();
            return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new LowerCaseFilter((TokenStream)tokenizer));
        }
    };
    private static final Analyzer LETTER_OR_DIGIT_ANALYZER = new Analyzer(){

        protected Analyzer.TokenStreamComponents createComponents(String filedName) {
            LetterOrDigitTokenizer tokenizer = new LetterOrDigitTokenizer();
            return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, (TokenStream)new LowerCaseFilter((TokenStream)tokenizer));
        }
    };

    public NexusAnalyzer() {
        super(PER_FIELD_REUSE_STRATEGY);
    }

    protected Analyzer getWrappedAnalyzer(String fieldName) {
        if (JarFileContentsIndexCreator.FLD_CLASSNAMES_KW.getKey().equals(fieldName)) {
            return CLASS_NAMES_ANALYZER;
        }
        return LETTER_OR_DIGIT_ANALYZER;
    }

    public static class LetterOrDigitTokenizer
    extends CharTokenizer {
        protected boolean isTokenChar(int c) {
            return Character.isLetterOrDigit(c);
        }
    }

    @Deprecated
    public static class DeprecatedClassnamesTokenizer
    extends CharTokenizer {
        protected boolean isTokenChar(int i) {
            return i != 10;
        }
    }

    public static class NoopTokenizer
    extends CharTokenizer {
        protected boolean isTokenChar(int i) {
            return true;
        }
    }
}

