/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.parser.astnodes;

import java.util.Collections;
import java.util.List;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.php.editor.parser.astnodes.Attribute;
import org.netbeans.modules.php.editor.parser.astnodes.Block;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.TypeDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Visitor;

public class EnumDeclaration
extends TypeDeclaration {
    @NullAllowed
    private final Expression backingType;

    private EnumDeclaration(int start, int end, Identifier className, Expression backingType, Expression[] interfaces, Block body, List<Attribute> attributes) {
        super(start, end, className, interfaces, body, attributes);
        this.backingType = backingType;
    }

    private EnumDeclaration(int start, int end, Identifier className, Expression backingType, List<Expression> interfaces, Block body, List<Attribute> attributes) {
        this(start, end, className, backingType, interfaces == null ? null : interfaces.toArray(new Expression[0]), body, attributes);
    }

    public EnumDeclaration(int start, int end, Identifier name, @NullAllowed Expression backingType, List<Expression> interfaces, Block body) {
        this(start, end, name, backingType, interfaces, body, Collections.emptyList());
    }

    public static EnumDeclaration create(EnumDeclaration declaration, List<Attribute> attributes) {
        assert (attributes != null);
        int start = attributes.isEmpty() ? declaration.getStartOffset() : attributes.get(0).getStartOffset();
        return new EnumDeclaration(start, declaration.getEndOffset(), declaration.getName(), declaration.getBackingType(), declaration.getInterfaces(), declaration.getBody(), attributes);
    }

    @CheckForNull
    public Expression getBackingType() {
        return this.backingType;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        StringBuilder sbAttributes = new StringBuilder();
        this.getAttributes().forEach(attribute -> sbAttributes.append(attribute).append(" "));
        StringBuilder sb = new StringBuilder();
        for (Expression expression : this.getInterfaces()) {
            sb.append(expression).append(",");
        }
        return sbAttributes.toString() + "enum " + String.valueOf(this.getName()) + String.valueOf(this.backingType) == null ? "" : ": " + String.valueOf(this.backingType) + " implements " + String.valueOf(sb) + String.valueOf(this.getBody());
    }
}

