/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api;

import java.io.File;
import java.util.Map;

public interface HostInfo {
    public OS getOS();

    public CpuFamily getCpuFamily();

    public int getCpuNum();

    public OSFamily getOSFamily();

    public String getHostname();

    public String getLoginShell();

    public String getShell();

    public Map<String, String> getEnvironment();

    public String getTempDir();

    public File getTempDirFile();

    public String getUserDir();

    public File getUserDirFile();

    public int getUserId();

    public int getGroupId();

    public String getGroup();

    public int[] getAllGroupIDs();

    public String[] getAllGroups();

    public long getClockSkew();

    public String getEnvironmentFile();

    public static interface OS {
        public OSFamily getFamily();

        public String getName();

        public String getVersion();

        public Bitness getBitness();
    }

    public static enum Bitness {
        _32,
        _64;


        public static Bitness valueOf(int bitness) {
            return bitness == 64 ? _64 : _32;
        }

        public String toString() {
            return this == _32 ? "32" : "64";
        }
    }

    public static enum OSFamily {
        SUNOS,
        LINUX,
        WINDOWS,
        MACOSX,
        FREEBSD,
        UNKNOWN;


        public boolean isUnix() {
            switch (this.ordinal()) {
                case 0: 
                case 1: 
                case 3: 
                case 4: {
                    return true;
                }
                case 2: {
                    return false;
                }
                case 5: {
                    return false;
                }
            }
            throw new IllegalStateException("Unexpected OSFamily: " + (Object)((Object)this));
        }

        public String cname() {
            switch (this.ordinal()) {
                case 1: {
                    return "Linux";
                }
                case 3: {
                    return "MacOSX";
                }
                case 0: {
                    return "SunOS";
                }
                case 4: {
                    return "FreeBSD";
                }
                case 2: {
                    return "Windows";
                }
                case 5: {
                    return "UNKNOWN";
                }
            }
            throw new IllegalStateException("Unexpected OSFamily: " + (Object)((Object)this));
        }
    }

    public static enum CpuFamily {
        SPARC,
        X86,
        ARM,
        AARCH64,
        UNKNOWN;

    }
}

