/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.editor;

import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.websvc.rest.editor.RestConfigurationEditorAwareTaskFactory;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServices;
import org.netbeans.modules.websvc.rest.model.api.RestServicesMetadata;
import org.netbeans.modules.websvc.rest.model.api.RestServicesModel;
import org.netbeans.modules.websvc.rest.spi.RestSupport;
import org.netbeans.spi.editor.hints.ChangeInfo;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;

abstract class BaseRestConfigurationFix
implements Fix {
    private Project project;
    private RestConfigurationEditorAwareTaskFactory factory;
    private FileObject fileObject;
    private ClasspathInfo cpInfo;

    BaseRestConfigurationFix(Project project, FileObject fileObject, RestConfigurationEditorAwareTaskFactory factory, ClasspathInfo cpInfo) {
        this.project = project;
        this.fileObject = fileObject;
        this.factory = factory;
        this.cpInfo = cpInfo;
    }

    public ChangeInfo implement() throws Exception {
        RestServicesModel servicesModel = this.getSupport().getRestServicesModel();
        final Set fqns = (Set)servicesModel.runReadAction((MetadataModelAction)new MetadataModelAction<RestServicesMetadata, Set<String>>(){

            public Set<String> run(RestServicesMetadata metadata) throws Exception {
                RestServiceDescription[] descriptions;
                HashSet<String> restFqns = new HashSet<String>();
                RestServices services = metadata.getRoot();
                for (RestServiceDescription description : descriptions = services.getRestServiceDescription()) {
                    restFqns.add(description.getClassName());
                }
                return restFqns;
            }
        });
        JavaSource javaSource = JavaSource.create((ClasspathInfo)this.cpInfo, (FileObject[])new FileObject[0]);
        final HashSet packs = new HashSet();
        javaSource.runUserActionTask((Task)new Task<CompilationController>(){
            final /* synthetic */ BaseRestConfigurationFix this$0;
            {
                this.this$0 = this$0;
            }

            public void run(CompilationController controller) throws Exception {
                packs.addAll(this.this$0.getPackages(fqns, controller));
            }
        }, true);
        this.getSupport().configure(packs.toArray(new String[0]));
        this.factory.restart(this.fileObject);
        return null;
    }

    protected RestSupport getSupport() {
        return (RestSupport)this.project.getLookup().lookup(RestSupport.class);
    }

    protected Project getProject() {
        return this.project;
    }

    protected RestConfigurationEditorAwareTaskFactory getFactory() {
        return this.factory;
    }

    protected FileObject getFileObject() {
        return this.fileObject;
    }

    private Set<String> getPackages(Set<String> fqns, CompilationController controller) {
        HashSet<String> set = new HashSet<String>();
        Set<TypeElement> restElements = this.getRestElements(fqns, controller);
        for (TypeElement typeElement : restElements) {
            PackageElement pack = controller.getElements().getPackageOf(typeElement);
            set.add(pack.getQualifiedName().toString());
        }
        return set;
    }

    private Set<TypeElement> getRestElements(Set<String> fqns, CompilationController controller) {
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        for (String fqn : fqns) {
            TypeElement typeElement = controller.getElements().getTypeElement(fqn);
            if (typeElement == null) continue;
            result.add(typeElement);
        }
        return result;
    }
}

