/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.output.dataexport;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.progress.BaseProgressUtils;
import org.netbeans.modules.db.dataview.output.DataViewTableUIModel;
import org.netbeans.modules.db.dataview.output.dataexport.Bundle;
import org.netbeans.modules.db.dataview.output.dataexport.CSVDataExporter;
import org.netbeans.modules.db.dataview.output.dataexport.DataExportUtils;
import org.netbeans.modules.db.dataview.output.dataexport.DataExporter;
import org.netbeans.modules.db.dataview.output.dataexport.TSVDataExporter;
import org.netbeans.modules.db.dataview.output.dataexport.XLSXDataExporter;
import org.openide.util.Utilities;

public class DataViewTableDataExportFileChooser {
    private static final List<DataExporter> EXPORTERS = Arrays.asList(new CSVDataExporter(), new TSVDataExporter(), new XLSXDataExporter());
    private static File previouslySelectedDirectory;

    public static synchronized void extractAsFile(DataViewTableUIModel model) {
        JFileChooser fc = DataViewTableDataExportFileChooser.initializeFileChooser();
        int returnVal = fc.showDialog(null, Bundle.LBL_FILE_CHOOSER());
        switch (returnVal) {
            case 0: {
                FileFilter filter = fc.getFileFilter();
                previouslySelectedDirectory = fc.getCurrentDirectory();
                DataExporter selectedExporter = EXPORTERS.stream().filter(exporter -> exporter.getFileFilter() == filter).findAny().orElseThrow(() -> new AssertionError((Object)"No matching file exporter filter found."));
                File file = DataViewTableDataExportFileChooser.checkFileExtension(fc.getSelectedFile(), selectedExporter);
                if (!DataViewTableDataExportFileChooser.checkFile(file)) break;
                String[] columnNames = DataExportUtils.getColumnNames(model);
                Object[][] content = DataExportUtils.getTableContents(model);
                BaseProgressUtils.showProgressDialogAndRun(() -> selectedExporter.exportData(columnNames, content, file), (String)Bundle.MSG_EXPORT_DATA());
            }
        }
    }

    private static boolean checkFile(File file) {
        if (file.exists()) {
            int a = JOptionPane.showConfirmDialog(Utilities.findDialogParent(), Bundle.LBL_OVEWRITE_DIALOG(), Bundle.MSG_OVEWRITE_DIALOG(), 0);
            return a == 0;
        }
        return true;
    }

    private static File checkFileExtension(File file, DataExporter exporter) {
        if (!exporter.handlesFileFormat(file)) {
            return new File(file.getAbsolutePath() + "." + exporter.getDefaultFileExtension());
        }
        return file;
    }

    private static JFileChooser initializeFileChooser() {
        JFileChooser fc = new JFileChooser();
        fc.setAcceptAllFileFilterUsed(false);
        EXPORTERS.forEach(exporter -> fc.addChoosableFileFilter(exporter.getFileFilter()));
        if (previouslySelectedDirectory != null) {
            fc.setCurrentDirectory(previouslySelectedDirectory);
        }
        fc.setFileFilter(EXPORTERS.get(0).getFileFilter());
        return fc;
    }
}

