/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.tasklist;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.tasklist.Bundle;
import org.netbeans.modules.hudson.tasklist.JobScanner;
import org.netbeans.modules.hudson.ui.spi.ProjectHudsonProvider;
import org.netbeans.spi.tasklist.PushTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class HudsonScanner
extends PushTaskScanner
implements Runnable {
    private static final Logger LOG = Logger.getLogger(HudsonScanner.class.getName());
    private RequestProcessor.Task task;
    private Thread taskThread;
    private TaskScanningScope scope;
    private PushTaskScanner.Callback callback;
    private final Map<Project, CacheEntry> cache = new WeakHashMap<Project, CacheEntry>();

    public HudsonScanner() {
        super(Bundle.HudsonScanner_displayName(), Bundle.HudsonScanner_description(), null);
    }

    public void setScope(TaskScanningScope scope, PushTaskScanner.Callback callback) {
        try {
            if (!NbPreferences.root().nodeExists("org/netbeans/modules/hudson/instances")) {
                return;
            }
        }
        catch (BackingStoreException x) {
            LOG.log(Level.INFO, null, x);
        }
        this.doSetScope(scope, callback);
    }

    private void doSetScope(TaskScanningScope scope, PushTaskScanner.Callback callback) {
        if (this.task == null) {
            this.task = new RequestProcessor(HudsonScanner.class).create((Runnable)this);
            this.task.setPriority(1);
        }
        if (scope == null) {
            LOG.fine("canceling scan");
            this.task.cancel();
            if (this.taskThread != null) {
                this.taskThread.interrupt();
            }
            return;
        }
        this.scope = scope;
        this.callback = callback;
        if (scope.getLookup().lookup(Project.class) == null) {
            LOG.finer("no projects to scan");
            callback.clearAllTasks();
            return;
        }
        LOG.fine("scheduling scan");
        this.task.schedule(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.callback.started();
        this.taskThread = Thread.currentThread();
        try {
            final ArrayList<Task> tasks = new ArrayList<Task>();
            for (Project p : this.scope.getLookup().lookupAll(Project.class)) {
                HudsonJob job;
                if (Thread.interrupted()) {
                    return;
                }
                ProjectHudsonProvider.Association assoc = ProjectHudsonProvider.getDefault().findAssociation(p);
                if (assoc == null || (job = assoc.getJob()) == null) continue;
                CacheEntry entry = this.cache.get(p);
                if (entry == null) {
                    entry = new CacheEntry();
                    this.cache.put(p, entry);
                }
                List<Task> cachedTasks = entry.tasks;
                int lastSuccessfulBuild = job.getLastSuccessfulBuild();
                String jobUrl = job.getUrl();
                if (cachedTasks == null || lastSuccessfulBuild != entry.lastSuccessfulBuild || !jobUrl.equals(entry.jobUrl)) {
                    final ArrayList<Task> newTasks = new ArrayList<Task>();
                    for (JobScanner s : Lookup.getDefault().lookupAll(JobScanner.class)) {
                        if (Thread.interrupted()) {
                            return;
                        }
                        try {
                            final AtomicInteger count = new AtomicInteger();
                            s.findTasks(p, job, lastSuccessfulBuild, new JobScanner.TaskAdder(){
                                final /* synthetic */ HudsonScanner this$0;
                                {
                                    this.this$0 = this$0;
                                }

                                @Override
                                public void add(Task task) {
                                    count.incrementAndGet();
                                    newTasks.add(task);
                                    tasks.add(task);
                                    this.this$0.callback.setTasks(tasks);
                                }
                            });
                            LOG.log(Level.FINE, "discovered {0} tasks for {1} from {2}", new Object[]{count, p, s});
                        }
                        catch (IOException x) {
                            LOG.log(Level.INFO, "from " + assoc, x);
                        }
                        catch (RuntimeException x) {
                            LOG.log(Level.WARNING, "from " + assoc, x);
                        }
                    }
                    entry.tasks = newTasks;
                    entry.lastSuccessfulBuild = lastSuccessfulBuild;
                    entry.jobUrl = jobUrl;
                    continue;
                }
                LOG.log(Level.FINE, "using {0} cached tasks for {1}", new Object[]{cachedTasks.size(), p});
                tasks.addAll(cachedTasks);
                this.callback.setTasks(tasks);
            }
        }
        finally {
            this.taskThread = null;
            this.callback.finished();
        }
    }

    private static class CacheEntry {
        String jobUrl;
        int lastSuccessfulBuild;
        List<Task> tasks;

        private CacheEntry() {
        }
    }
}

