/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.el;

import com.sun.el.parser.AstIdentifier;
import com.sun.el.parser.Node;
import com.sun.el.parser.NodeVisitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.lang.model.element.Element;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OccurrencesFinder;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.web.el.CompilationContext;
import org.netbeans.modules.web.el.ELElement;
import org.netbeans.modules.web.el.ELParserResult;
import org.netbeans.modules.web.el.ELTypeUtilities;
import org.netbeans.modules.web.el.ResourceBundles;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Pair;

final class ELOccurrencesFinder
extends OccurrencesFinder {
    private int caretPosition;
    private boolean cancelled;
    private final Map<OffsetRange, ColoringAttributes> occurrences = new HashMap<OffsetRange, ColoringAttributes>();

    public void setCaretPosition(int position) {
        this.caretPosition = position;
    }

    public Map getOccurrences() {
        return this.occurrences;
    }

    public void run(Parser.Result result, SchedulerEvent event) {
        this.occurrences.clear();
        if (this.checkAndResetCancel()) {
            return;
        }
        this.computeOccurrences((ELParserResult)result);
    }

    public int getPriority() {
        return 200;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    public void cancel() {
        this.cancelled = true;
    }

    private void computeOccurrences(final ELParserResult parserResult) {
        ELElement current = parserResult.getElementAt(this.caretPosition);
        if (current == null) {
            return;
        }
        final Node targetNode = current.findNodeAt(this.caretPosition);
        if (targetNode == null || targetNode.getImage() == null) {
            return;
        }
        final Pair target = Pair.of((Object)current, (Object)targetNode);
        final ArrayList matching = new ArrayList();
        for (final ELElement eLElement : parserResult.getElements()) {
            if (this.checkAndResetCancel()) {
                return;
            }
            if (!eLElement.isValid()) continue;
            eLElement.getNode().accept(new NodeVisitor(){
                final /* synthetic */ ELOccurrencesFinder this$0;
                {
                    this.this$0 = this$0;
                }

                public void visit(Node node) throws ELException {
                    if (node.getClass().equals(targetNode.getClass()) && targetNode.getImage().equals(node.getImage())) {
                        matching.add(Pair.of((Object)eLElement, (Object)node));
                    }
                }
            });
        }
        final FileObject file = parserResult.getFileObject();
        JavaSource jsource = JavaSource.create((ClasspathInfo)ELTypeUtilities.getElimplExtendedCPI(file), (FileObject[])new FileObject[0]);
        try {
            jsource.runUserActionTask((Task)new Task<CompilationController>(){
                final /* synthetic */ ELOccurrencesFinder this$0;
                {
                    this.this$0 = this$0;
                }

                public void run(CompilationController info) throws Exception {
                    info.toPhase(JavaSource.Phase.RESOLVED);
                    this.this$0.occurrences.putAll(this.this$0.findMatchingTypes(CompilationContext.create(file, (CompilationInfo)info), parserResult, (Pair<ELElement, Node>)target, matching));
                }
            }, true);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        if (this.occurrences.isEmpty()) {
            this.occurrences.putAll(this.findMatchingResourceBundleKeys((Pair<ELElement, Node>)target, parserResult));
        }
    }

    private Map<OffsetRange, ColoringAttributes> findMatchingResourceBundleKeys(Pair<ELElement, Node> target, ELParserResult parserResult) {
        ResourceBundles resourceBundles = ResourceBundles.get(parserResult.getFileObject());
        if (!resourceBundles.canHaveBundles()) {
            return Collections.emptyMap();
        }
        ArrayList<Pair<AstIdentifier, Node>> keys = new ArrayList<Pair<AstIdentifier, Node>>();
        keys.addAll(resourceBundles.collectKeys(((ELElement)target.first()).getNode()));
        if (keys.isEmpty()) {
            return Collections.emptyMap();
        }
        boolean found = false;
        for (Pair pair : keys) {
            if (!((Node)pair.second()).equals(target.second())) continue;
            found = true;
            break;
        }
        if (!found) {
            return Collections.emptyMap();
        }
        HashMap<OffsetRange, ColoringAttributes> result = new HashMap<OffsetRange, ColoringAttributes>();
        for (ELElement each : parserResult.getElements()) {
            if (!each.isValid()) continue;
            for (Pair<AstIdentifier, Node> candidate : resourceBundles.collectKeys(each.getNode())) {
                if (!((Node)candidate.second()).equals(target.second())) continue;
                OffsetRange range = each.getOriginalOffset((Node)candidate.second());
                result.put(range, ColoringAttributes.MARK_OCCURRENCES);
            }
        }
        return result;
    }

    private Map<OffsetRange, ColoringAttributes> findMatchingTypes(CompilationContext info, ELParserResult parserResult, Pair<ELElement, Node> target, List<Pair<ELElement, Node>> candidates) {
        Element targetType = ELTypeUtilities.resolveElement(info, (ELElement)target.first(), (Node)target.second());
        HashMap<OffsetRange, ColoringAttributes> result = new HashMap<OffsetRange, ColoringAttributes>();
        for (Pair<ELElement, Node> candidate : candidates) {
            if (this.checkAndResetCancel()) {
                return result;
            }
            Element type = ELTypeUtilities.resolveElement(info, (ELElement)candidate.first(), (Node)candidate.second());
            if (type == null || !type.equals(targetType)) continue;
            OffsetRange range = ((ELElement)candidate.first()).getOriginalOffset((Node)candidate.second());
            result.put(range, ColoringAttributes.MARK_OCCURRENCES);
        }
        return result;
    }

    private boolean checkAndResetCancel() {
        if (this.cancelled) {
            this.cancelled = false;
            return true;
        }
        return false;
    }
}

