/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.index.processor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.springframework.context.index.processor.CandidateComponentsMetadata;
import org.springframework.context.index.processor.ItemMetadata;
import org.springframework.context.index.processor.TypeHelper;

class MetadataCollector {
    private final List<ItemMetadata> metadataItems = new ArrayList<ItemMetadata>();
    private final ProcessingEnvironment processingEnvironment;
    private final CandidateComponentsMetadata previousMetadata;
    private final TypeHelper typeHelper;
    private final Set<String> processedSourceTypes = new HashSet<String>();

    public MetadataCollector(ProcessingEnvironment processingEnvironment, CandidateComponentsMetadata previousMetadata) {
        this.processingEnvironment = processingEnvironment;
        this.previousMetadata = previousMetadata;
        this.typeHelper = new TypeHelper(processingEnvironment);
    }

    public void processing(RoundEnvironment roundEnv) {
        for (Element element : roundEnv.getRootElements()) {
            this.markAsProcessed(element);
        }
    }

    private void markAsProcessed(Element element) {
        if (element instanceof TypeElement) {
            this.processedSourceTypes.add(this.typeHelper.getType(element));
        }
    }

    public void add(ItemMetadata metadata) {
        this.metadataItems.add(metadata);
    }

    public CandidateComponentsMetadata getMetadata() {
        CandidateComponentsMetadata metadata = new CandidateComponentsMetadata();
        for (ItemMetadata item : this.metadataItems) {
            metadata.add(item);
        }
        if (this.previousMetadata != null) {
            List<ItemMetadata> items = this.previousMetadata.getItems();
            for (ItemMetadata item : items) {
                if (!this.shouldBeMerged(item)) continue;
                metadata.add(item);
            }
        }
        return metadata;
    }

    private boolean shouldBeMerged(ItemMetadata itemMetadata) {
        String sourceType = itemMetadata.getType();
        return sourceType != null && !this.deletedInCurrentBuild(sourceType) && !this.processedInCurrentBuild(sourceType);
    }

    private boolean deletedInCurrentBuild(String sourceType) {
        return this.processingEnvironment.getElementUtils().getTypeElement(sourceType) == null;
    }

    private boolean processedInCurrentBuild(String sourceType) {
        return this.processedSourceTypes.contains(sourceType);
    }
}

