/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.cdnjs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class Version {
    private static final Set<String> PRE_VERSIONS = new HashSet<String>();
    private final Fragment[] fragments;

    public static Version parse(String versionName) {
        ArrayList<Fragment> list = new ArrayList<Fragment>();
        list.add(new Fragment(0L, ""));
        boolean isNumber = false;
        boolean isText = false;
        long number = 0L;
        StringBuilder textBuilder = new StringBuilder();
        String version = versionName + ".";
        for (int i = 0; i < version.length(); ++i) {
            boolean letter;
            char c = version.charAt(i);
            boolean digit = '0' <= c && c <= '9';
            boolean bl = letter = 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
            if (isNumber && !digit) {
                isNumber = false;
                list.add(new Fragment(number, ""));
                number = 0L;
            } else if (isText && !letter) {
                isText = false;
                String text = textBuilder.toString();
                if (PRE_VERSIONS.contains(text.toLowerCase())) {
                    Fragment previous = (Fragment)list.get(list.size() - 1);
                    list.set(list.size() - 1, new Fragment(previous.getNumber() - 1L, previous.getText()));
                    list.add(new Fragment(Long.MAX_VALUE, text));
                } else {
                    list.add(new Fragment(0L, text));
                }
                textBuilder.setLength(0);
            }
            if (digit) {
                isNumber = true;
                number *= 10L;
                number += (long)(c - 48);
                continue;
            }
            if (!letter) continue;
            isText = true;
            textBuilder.append(c);
        }
        return new Version(list);
    }

    private Version(List<Fragment> fragmentList) {
        this.fragments = fragmentList.toArray(new Fragment[0]);
    }

    private int getFragmentCount() {
        return this.fragments.length;
    }

    private Fragment getFragment(int index) {
        return this.fragments[index];
    }

    static {
        PRE_VERSIONS.add("pre");
        PRE_VERSIONS.add("dev");
        PRE_VERSIONS.add("alpha");
        PRE_VERSIONS.add("beta");
        PRE_VERSIONS.add("rc");
    }

    private static final class Fragment {
        private final long number;
        private final String text;

        Fragment(long number, String text) {
            assert (text != null);
            this.number = number;
            this.text = text;
        }

        long getNumber() {
            return this.number;
        }

        String getText() {
            return this.text;
        }

        public String toString() {
            return this.text == null ? Long.toString(this.number) : "(" + this.number + "," + this.text + ")";
        }
    }

    public static final class Comparator
    implements java.util.Comparator<Version> {
        private static final java.util.Comparator<Version> ASCENDING_INSTANCE = new Comparator();
        private static final java.util.Comparator<Version> DESCENDING_INSTANCE = new java.util.Comparator<Version>(){

            @Override
            public int compare(Version version1, Version version2) {
                return ASCENDING_INSTANCE.compare(version2, version1);
            }
        };

        public static java.util.Comparator<Version> getInstance(boolean ascending) {
            return ascending ? ASCENDING_INSTANCE : DESCENDING_INSTANCE;
        }

        @Override
        public int compare(Version version1, Version version2) {
            int minLength = Math.min(version1.getFragmentCount(), version2.getFragmentCount());
            for (int i = 0; i < minLength; ++i) {
                long number2;
                Fragment fragment1 = version1.getFragment(i);
                Fragment fragment2 = version2.getFragment(i);
                long number1 = fragment1.getNumber();
                if (number1 < (number2 = fragment2.getNumber())) {
                    return -1;
                }
                if (number1 > number2) {
                    return 1;
                }
                int textDiff = fragment1.getText().compareTo(fragment2.getText());
                if (textDiff == 0) continue;
                return textDiff;
            }
            return version1.getFragmentCount() - version2.getFragmentCount();
        }
    }
}

