/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ant.freeform.spi.HelpIDFragmentProvider;
import org.openide.ErrorManager;

public class Util {
    public static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.ant.freeform");
    private static final Pattern VALIDATION = Pattern.compile("([A-Za-z0-9])+");

    private Util() {
    }

    public static String getMergedHelpIDFragments(Project p) {
        ArrayList<String> fragments = new ArrayList<String>();
        for (HelpIDFragmentProvider provider : p.getLookup().lookupAll(HelpIDFragmentProvider.class)) {
            String fragment = provider.getHelpIDFragment();
            if (fragment == null || !VALIDATION.matcher(fragment).matches()) {
                throw new IllegalStateException("HelpIDFragmentProvider \"" + provider + "\" provided invalid help ID fragment \"" + fragment + "\".");
            }
            fragments.add(fragment);
        }
        Collections.sort(fragments);
        StringBuffer result = new StringBuffer();
        Iterator i = fragments.iterator();
        while (i.hasNext()) {
            result.append((String)i.next());
            if (!i.hasNext()) continue;
            result.append('.');
        }
        return result.toString();
    }
}

