/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Collections;
import java.util.logging.Level;
import javax.swing.text.Document;
import javax.swing.text.StyledDocument;
import org.netbeans.api.actions.Editable;
import org.netbeans.api.actions.Savable;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.ModificationResult;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.javafx2.editor.actions.Bundle;
import org.netbeans.modules.javafx2.editor.actions.ControllerFileMaker;
import org.netbeans.modules.javafx2.editor.actions.ControllerGenerator;
import org.netbeans.modules.javafx2.editor.completion.model.FxModel;
import org.netbeans.modules.javafx2.editor.completion.model.FxmlParserResult;
import org.netbeans.modules.javafx2.editor.fxml.FXMLDataObject;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;

public final class GenerateControllerAction
implements ActionListener {
    private final FXMLDataObject context;

    public GenerateControllerAction(FXMLDataObject context) {
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        DataObject controllerFile;
        Source s = Source.create((FileObject)this.context.getPrimaryFile());
        ControllerFileMaker fileMaker = new ControllerFileMaker((DataObject)this.context);
        try {
            controllerFile = fileMaker.getControllerFile();
            if (controllerFile == null) {
                return;
            }
        }
        catch (IOException ex) {
            Exceptions.attachSeverity((Throwable)ex, (Level)Level.WARNING);
            Exceptions.printStackTrace((Throwable)Exceptions.attachMessage((Throwable)ex, (String)Bundle.ERR_CannotCreateController(ex.getLocalizedMessage())));
            return;
        }
        final ModificationResult[] result = new ModificationResult[1];
        try {
            ParserManager.parse(Collections.singletonList(s), (UserTask)new UserTask(this){
                final /* synthetic */ GenerateControllerAction this$0;
                {
                    this.this$0 = this$0;
                }

                public void run(ResultIterator iter) throws Exception {
                    FxmlParserResult fxmlResult = (FxmlParserResult)iter.getParserResult();
                    FxModel model = fxmlResult.getSourceModel();
                    ControllerGenerator gen = new ControllerGenerator(fxmlResult, controllerFile);
                    result[0] = JavaSource.forFileObject((FileObject)controllerFile.getPrimaryFile()).runModificationTask((Task)gen);
                }
            });
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return;
        }
        try {
            Savable save;
            ModificationResult res = result[0];
            res.commit();
            if (!fileMaker.hasControllerName()) {
                EditorCookie edit = (EditorCookie)this.context.getLookup().lookup(EditorCookie.class);
                boolean mod = edit.isModified();
                StyledDocument sd = edit.openDocument();
                s = Source.create((Document)sd);
                ControllerGenerator.generateControllerAttribute(s, fileMaker.getControllerClassName());
                if (!mod) {
                    edit.saveDocument();
                }
            }
            if ((save = (Savable)controllerFile.getLookup().lookup(Savable.class)) != null) {
                save.save();
            }
            if (res.getDifferences(controllerFile.getPrimaryFile()) != null) {
                Editable ed = (Editable)controllerFile.getLookup().lookup(Editable.class);
                ed.edit();
            }
        }
        catch (ParseException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }
}

