/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetRepoFileDiffRequest
extends BmcRequest<Void> {
    private String repositoryId;
    private String baseVersion;
    private String targetVersion;
    private String filePath;
    private Boolean isComparisonFromMergeBase;
    private String opcRequestId;

    public String getRepositoryId() {
        return this.repositoryId;
    }

    public String getBaseVersion() {
        return this.baseVersion;
    }

    public String getTargetVersion() {
        return this.targetVersion;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public Boolean getIsComparisonFromMergeBase() {
        return this.isComparisonFromMergeBase;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().repositoryId(this.repositoryId).baseVersion(this.baseVersion).targetVersion(this.targetVersion).filePath(this.filePath).isComparisonFromMergeBase(this.isComparisonFromMergeBase).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",repositoryId=").append(String.valueOf(this.repositoryId));
        sb.append(",baseVersion=").append(String.valueOf(this.baseVersion));
        sb.append(",targetVersion=").append(String.valueOf(this.targetVersion));
        sb.append(",filePath=").append(String.valueOf(this.filePath));
        sb.append(",isComparisonFromMergeBase=").append(String.valueOf(this.isComparisonFromMergeBase));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetRepoFileDiffRequest)) {
            return false;
        }
        GetRepoFileDiffRequest other = (GetRepoFileDiffRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.repositoryId, other.repositoryId) && Objects.equals(this.baseVersion, other.baseVersion) && Objects.equals(this.targetVersion, other.targetVersion) && Objects.equals(this.filePath, other.filePath) && Objects.equals(this.isComparisonFromMergeBase, other.isComparisonFromMergeBase) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.repositoryId == null ? 43 : this.repositoryId.hashCode());
        result = result * 59 + (this.baseVersion == null ? 43 : this.baseVersion.hashCode());
        result = result * 59 + (this.targetVersion == null ? 43 : this.targetVersion.hashCode());
        result = result * 59 + (this.filePath == null ? 43 : this.filePath.hashCode());
        result = result * 59 + (this.isComparisonFromMergeBase == null ? 43 : this.isComparisonFromMergeBase.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetRepoFileDiffRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String repositoryId = null;
        private String baseVersion = null;
        private String targetVersion = null;
        private String filePath = null;
        private Boolean isComparisonFromMergeBase = null;
        private String opcRequestId = null;

        public Builder repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            return this;
        }

        public Builder baseVersion(String baseVersion) {
            this.baseVersion = baseVersion;
            return this;
        }

        public Builder targetVersion(String targetVersion) {
            this.targetVersion = targetVersion;
            return this;
        }

        public Builder filePath(String filePath) {
            this.filePath = filePath;
            return this;
        }

        public Builder isComparisonFromMergeBase(Boolean isComparisonFromMergeBase) {
            this.isComparisonFromMergeBase = isComparisonFromMergeBase;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetRepoFileDiffRequest o) {
            this.repositoryId(o.getRepositoryId());
            this.baseVersion(o.getBaseVersion());
            this.targetVersion(o.getTargetVersion());
            this.filePath(o.getFilePath());
            this.isComparisonFromMergeBase(o.getIsComparisonFromMergeBase());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetRepoFileDiffRequest build() {
            GetRepoFileDiffRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetRepoFileDiffRequest buildWithoutInvocationCallback() {
            GetRepoFileDiffRequest request = new GetRepoFileDiffRequest();
            request.repositoryId = this.repositoryId;
            request.baseVersion = this.baseVersion;
            request.targetVersion = this.targetVersion;
            request.filePath = this.filePath;
            request.isComparisonFromMergeBase = this.isComparisonFromMergeBase;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

