/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.hints.css;

import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.spi.support.ModificationResult;
import org.netbeans.modules.css.model.api.ElementHandle;
import org.netbeans.modules.css.model.api.Model;
import org.netbeans.modules.css.model.api.ModelUtils;
import org.netbeans.modules.css.model.api.Rule;
import org.netbeans.modules.css.model.api.StyleSheet;
import org.netbeans.modules.html.editor.HtmlSourceUtils;
import org.netbeans.modules.html.editor.Utils;
import org.netbeans.modules.html.editor.hints.css.Bundle;
import org.netbeans.modules.html.editor.lib.api.HtmlParsingResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.common.api.WebUtils;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;

public class CreateRuleInStylesheet
implements HintFix {
    private static final String NEW_STYLESHEET_NAME = "style.css";
    private FileObject externalStylesheet;
    private final FileObject sourceFile;
    private final String ruleName;
    private final String path;
    private final boolean importStyleSheet;
    private final boolean createStyleSheet;

    public CreateRuleInStylesheet(FileObject sourceFile, FileObject externalStylesheet, String ruleName, boolean importStylesheet, boolean createStyleSheet) {
        this.sourceFile = sourceFile;
        this.externalStylesheet = externalStylesheet;
        this.ruleName = ruleName;
        this.importStyleSheet = importStylesheet;
        this.createStyleSheet = createStyleSheet;
        this.path = externalStylesheet != null ? WebUtils.getRelativePath((FileObject)sourceFile, (FileObject)externalStylesheet) : null;
    }

    private String getSelectorText() {
        return this.ruleName;
    }

    public String getDescription() {
        if (this.createStyleSheet) {
            return Bundle.description_create_rule_and_import_new_stylesheet(this.getSelectorText(), NEW_STYLESHEET_NAME);
        }
        if (this.importStyleSheet) {
            return Bundle.description_create_rule_and_import_stylesheet(this.getSelectorText(), this.path);
        }
        return Bundle.description_create_rule_in_stylesheet(this.getSelectorText(), this.path);
    }

    public void implement() throws Exception {
        if (this.createStyleSheet) {
            FileObject folder = this.sourceFile.getParent();
            this.externalStylesheet = FileUtil.createData((FileObject)folder, (String)NEW_STYLESHEET_NAME);
        }
        if (this.importStyleSheet) {
            Source source = Source.create((FileObject)this.sourceFile);
            Document doc = source.getDocument(false);
            ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result result = resultIterator.getParserResult();
                    if (!(result instanceof HtmlParsingResult)) {
                        return;
                    }
                    ModificationResult modification = new ModificationResult();
                    if (HtmlSourceUtils.importStyleSheet(modification, (HtmlParsingResult)result, result.getSnapshot(), CreateRuleInStylesheet.this.externalStylesheet)) {
                        modification.commit();
                    }
                }
            });
        }
        final Model model = Utils.createCssSourceModel(Source.create((FileObject)this.externalStylesheet));
        final AtomicReference handleRef = new AtomicReference();
        model.runWriteTask(new Model.ModelTask(){
            final /* synthetic */ CreateRuleInStylesheet this$0;
            {
                this.this$0 = this$0;
            }

            public void run(StyleSheet styleSheet) {
                try {
                    ModelUtils utils = new ModelUtils(model);
                    Rule rule = utils.createRule(Collections.singleton(this.this$0.getSelectorText()), Collections.emptyList());
                    utils.getBody().addRule(rule);
                    handleRef.set(rule.getElementHandle());
                    model.applyChanges();
                }
                catch (IOException | BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        final Model newmodel = Utils.createCssSourceModel(Source.create((FileObject)this.externalStylesheet));
        model.runReadTask(new Model.ModelTask(){
            final /* synthetic */ CreateRuleInStylesheet this$0;
            {
                this.this$0 = this$0;
            }

            public void run(StyleSheet styleSheet) {
                Rule rule = (Rule)((ElementHandle)handleRef.get()).resolve(newmodel);
                if (rule != null) {
                    this.this$0.openLocation(this.this$0.externalStylesheet, rule.getStartOffset());
                }
            }
        });
    }

    private void openLocation(FileObject file, final int offset) {
        try {
            DataObject dob = DataObject.find((FileObject)file);
            final EditorCookie ec = (EditorCookie)dob.getLookup().lookup(EditorCookie.class);
            if (ec != null) {
                Mutex.EVENT.readAccess(new Runnable(){
                    final /* synthetic */ CreateRuleInStylesheet this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        JEditorPane[] openedPanes = ec.getOpenedPanes();
                        if (openedPanes != null && openedPanes.length > 0) {
                            ec.open();
                            JEditorPane pane = openedPanes[0];
                            pane.setCaretPosition(offset);
                        } else {
                            try {
                                ec.openDocument();
                                ec.open();
                                openedPanes = ec.getOpenedPanes();
                                if (openedPanes != null && openedPanes.length > 0) {
                                    JEditorPane pane = openedPanes[0];
                                    pane.setCaretPosition(offset);
                                }
                            }
                            catch (IOException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                });
            }
        }
        catch (DataObjectNotFoundException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public boolean isSafe() {
        return true;
    }

    public boolean isInteractive() {
        return false;
    }
}

