/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlOperation;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlParameter;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlPort;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlService;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.core.JaxWsUtils;
import org.netbeans.modules.websvc.core.MethodVisitor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;

public class MethodGenerator {
    FileObject implClassFo;
    WsdlModel wsdlModel;

    public MethodGenerator(WsdlModel wsdlModel, FileObject implClassFo) {
        this.implClassFo = implClassFo;
        this.wsdlModel = wsdlModel;
    }

    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public void generateMethod(final String operationName) throws IOException {
        SaveCookie cookie;
        JavaSource targetSource = JavaSource.forFileObject((FileObject)this.implClassFo);
        CancellableTask<WorkingCopy> task = new CancellableTask<WorkingCopy>(){
            final /* synthetic */ MethodGenerator this$0;
            {
                this.this$0 = this$0;
            }

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.RESOLVED);
                ClassTree javaClass = SourceUtils.getPublicTopLevelTree((CompilationController)workingCopy);
                if (javaClass != null) {
                    WsdlOperation wsdlOperation = this.this$0.getWsdlOperation(operationName);
                    if (wsdlOperation != null) {
                        TreeMaker make = workingCopy.getTreeMaker();
                        String returnType = wsdlOperation.getReturnTypeName();
                        List parameters = wsdlOperation.getParameters();
                        ArrayList<VariableTree> params = new ArrayList<VariableTree>();
                        for (WsdlParameter parameter : parameters) {
                            params.add(make.Variable(make.Modifiers(Collections.emptySet(), Collections.emptyList()), (CharSequence)parameter.getName(), (Tree)make.Identifier((CharSequence)parameter.getTypeName()), null));
                        }
                        Iterator exceptions = wsdlOperation.getExceptions();
                        ArrayList<IdentifierTree> exc = new ArrayList<IdentifierTree>();
                        while (exceptions.hasNext()) {
                            String exception = (String)exceptions.next();
                            exc.add(make.Identifier((CharSequence)exception));
                        }
                        ModifiersTree methodModifiers = make.Modifiers(Collections.singleton(Modifier.PUBLIC), Collections.emptyList());
                        MethodTree method = make.Method(methodModifiers, (CharSequence)wsdlOperation.getJavaName(), (Tree)make.Identifier((CharSequence)returnType), Collections.emptyList(), params, exc, "{ //TODO implement this method\nthrow new UnsupportedOperationException(\"Not implemented yet.\") }", null);
                        ClassTree modifiedClass = make.addClassMember(javaClass, (Tree)method);
                        workingCopy.rewrite((Tree)javaClass, (Tree)modifiedClass);
                    } else {
                        Logger.getLogger(MethodGenerator.class.getName()).log(Level.INFO, "Failed to bind WSDL operation to java method: " + operationName);
                    }
                }
            }

            public void cancel() {
            }
        };
        targetSource.runModificationTask((Task)task).commit();
        DataObject dobj = DataObject.find((FileObject)this.implClassFo);
        if (dobj != null && (cookie = (SaveCookie)dobj.getCookie(SaveCookie.class)) != null) {
            cookie.save();
        }
    }

    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public static void deleteMethod(FileObject implClass, final String operationName) throws IOException {
        SaveCookie cookie;
        JavaSource targetSource = JavaSource.forFileObject((FileObject)implClass);
        CancellableTask<WorkingCopy> task = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                ClassTree javaClass = SourceUtils.getPublicTopLevelTree((CompilationController)workingCopy);
                if (javaClass != null) {
                    ExecutableElement method = new MethodVisitor((CompilationInfo)workingCopy).getMethod(operationName);
                    TreeMaker make = workingCopy.getTreeMaker();
                    if (method != null) {
                        MethodTree methodTree = workingCopy.getTrees().getTree(method);
                        ClassTree modifiedJavaClass = make.removeClassMember(javaClass, (Tree)methodTree);
                        workingCopy.rewrite((Tree)javaClass, (Tree)modifiedJavaClass);
                        boolean removeImplementsClause = false;
                        if (!new MethodVisitor((CompilationInfo)workingCopy).hasPublicMethod()) {
                            removeImplementsClause = true;
                        }
                        if (removeImplementsClause) {
                            List<? extends Tree> implementeds = javaClass.getImplementsClause();
                            for (Tree tree : implementeds) {
                                modifiedJavaClass = make.removeClassImplementsClause(modifiedJavaClass, tree);
                            }
                            workingCopy.rewrite((Tree)javaClass, (Tree)modifiedJavaClass);
                        }
                    }
                }
            }

            public void cancel() {
            }
        };
        targetSource.runModificationTask((Task)task).commit();
        DataObject dobj = DataObject.find((FileObject)implClass);
        if (dobj != null && (cookie = (SaveCookie)dobj.getCookie(SaveCookie.class)) != null) {
            cookie.save();
        }
    }

    @SuppressWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public static void removeMethod(FileObject implClass, final String operationName) throws IOException {
        SaveCookie cookie;
        JavaSource targetSource = JavaSource.forFileObject((FileObject)implClass);
        CancellableTask<WorkingCopy> task = new CancellableTask<WorkingCopy>(){

            public void run(WorkingCopy workingCopy) throws IOException {
                ExecutableElement method;
                workingCopy.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                TypeElement classEl = SourceUtils.getPublicTopLevelElement((CompilationController)workingCopy);
                if (classEl != null && (method = new MethodVisitor((CompilationInfo)workingCopy).getMethod(operationName)) != null) {
                    ClassTree javaClass = workingCopy.getTrees().getTree(classEl);
                    boolean foundWebServiceAnnotation = JaxWsUtils.hasAnnotation(classEl, "javax.jws.WebService");
                    boolean classHasWebMethods = new MethodVisitor((CompilationInfo)workingCopy).hasWebMethod();
                    TreeMaker make = workingCopy.getTreeMaker();
                    MethodTree methodTree = workingCopy.getTrees().getTree(method);
                    if (methodTree != null) {
                        if (foundWebServiceAnnotation) {
                            if (!classHasWebMethods) {
                                List<ExecutableElement> publicMethods = new MethodVisitor((CompilationInfo)workingCopy).getPublicMethods();
                                for (ExecutableElement m : publicMethods) {
                                    if (m == method) continue;
                                    List emptyList = Collections.emptyList();
                                    AnnotationTree annotationTree = make.Annotation((Tree)make.QualIdent("javax.jws.WebMethod"), emptyList);
                                    MethodTree mTree = workingCopy.getTrees().getTree(m);
                                    ModifiersTree modTree = mTree.getModifiers();
                                    ModifiersTree newModifiersTree = make.addModifiersAnnotation(modTree, annotationTree);
                                    workingCopy.rewrite((Tree)modTree, (Tree)newModifiersTree);
                                }
                            } else {
                                ModifiersTree modifiersTree = methodTree.getModifiers();
                                ModifiersTree newModTree = make.Modifiers(modifiersTree.getFlags());
                                workingCopy.rewrite((Tree)modifiersTree, (Tree)newModTree);
                            }
                        } else {
                            AnnotationMirror webMethodAnMirr = MethodGenerator.getWebMethodAnnotation(workingCopy, method);
                            if (webMethodAnMirr != null) {
                                ModifiersTree modifiersTree = methodTree.getModifiers();
                                AnnotationTree annotTree = (AnnotationTree)workingCopy.getTrees().getTree(classEl, webMethodAnMirr);
                                ModifiersTree newModTree = make.removeModifiersAnnotation(modifiersTree, annotTree);
                                workingCopy.rewrite((Tree)modifiersTree, (Tree)newModTree);
                            }
                        }
                        boolean removeImplementsClause = false;
                        if (foundWebServiceAnnotation) {
                            if (!new MethodVisitor((CompilationInfo)workingCopy).hasPublicMethod()) {
                                removeImplementsClause = true;
                            }
                        } else if (!new MethodVisitor((CompilationInfo)workingCopy).hasWebMethod()) {
                            removeImplementsClause = true;
                        }
                        if (removeImplementsClause) {
                            List<? extends Tree> implementeds = javaClass.getImplementsClause();
                            ClassTree modifiedJavaClass = javaClass;
                            for (Tree tree : implementeds) {
                                modifiedJavaClass = make.removeClassImplementsClause(modifiedJavaClass, tree);
                            }
                            workingCopy.rewrite((Tree)javaClass, (Tree)modifiedJavaClass);
                        }
                    }
                }
            }

            public void cancel() {
            }
        };
        targetSource.runModificationTask((Task)task).commit();
        DataObject dobj = DataObject.find((FileObject)implClass);
        if (dobj != null && (cookie = (SaveCookie)dobj.getCookie(SaveCookie.class)) != null) {
            cookie.save();
        }
    }

    private static AnnotationMirror getWebMethodAnnotation(WorkingCopy workingCopy, ExecutableElement method) {
        return JaxWsUtils.getAnnotation(method, "javax.jws.WebMethod");
    }

    private WsdlOperation getWsdlOperation(String operationName) {
        List services = this.wsdlModel.getServices();
        for (WsdlService service : services) {
            List ports = service.getPorts();
            for (WsdlPort port : ports) {
                List operations = port.getOperations();
                for (WsdlOperation operation : operations) {
                    if (!operationName.equals(operation.getName())) continue;
                    return operation;
                }
            }
        }
        return null;
    }
}

