/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.navigator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.BaseDocument;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.structure.api.DocumentElement;
import org.netbeans.modules.editor.structure.api.DocumentModel;
import org.netbeans.modules.editor.structure.api.DocumentModelException;
import org.netbeans.modules.xml.text.navigator.FilterActions;
import org.netbeans.modules.xml.text.navigator.FiltersDescription;
import org.netbeans.modules.xml.text.navigator.FiltersManager;
import org.netbeans.modules.xml.text.navigator.NavigatorTreeCellRenderer;
import org.netbeans.modules.xml.text.navigator.TapPanel;
import org.netbeans.modules.xml.text.navigator.TreeNodeAdapter;
import org.netbeans.modules.xml.text.navigator.base.AbstractXMLNavigatorContent;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.loaders.DataObject;
import org.openide.text.DataEditorSupport;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.UserQuestionException;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class NavigatorContent
extends AbstractXMLNavigatorContent
implements CaretListener,
Runnable {
    private static final Logger LOG = Logger.getLogger(NavigatorContent.class.getName());
    private static final boolean DEBUG = false;
    static boolean showAttributes = true;
    static boolean showContent = true;
    private volatile DataObject peerDO = null;
    private PropertyChangeListener peerWL = null;
    private final WeakHashMap uiCache = new WeakHashMap();
    private Reference<JTextComponent> activeEditor;
    private CaretListener wCaretL;
    private volatile boolean loading = false;
    private static final RequestProcessor RP = new RequestProcessor(NavigatorContent.class);

    public NavigatorContent() {
        this.setLayout(new BorderLayout());
    }

    private void editorReleased() {
        Reference<JTextComponent> jte = this.activeEditor;
        if (jte == null) {
            return;
        }
        JTextComponent c = jte.get();
        if (c == null) {
            return;
        }
        c.removeCaretListener(this.wCaretL);
        this.wCaretL = null;
    }

    private void updateActiveEditor() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(this);
            return;
        }
        JTextComponent c = this.findActivePane();
        if (c == null) {
            this.editorReleased();
            return;
        }
        if (this.activeEditor != null && this.activeEditor.get() == c) {
            return;
        }
        this.editorReleased();
        this.activeEditor = new WeakReference<JTextComponent>(c);
        this.wCaretL = (CaretListener)WeakListeners.create(CaretListener.class, (EventListener)this, (Object)c);
        c.addCaretListener(this);
        this.selectCurrentNode();
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        this.selectCurrentNode();
    }

    @Override
    public void run() {
        this.updateActiveEditor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void selectCurrentNode() {
        NavigatorContentPanel panel;
        assert (SwingUtilities.isEventDispatchThread()) : "Must be run in EDT";
        Reference<JTextComponent> active = this.activeEditor;
        if (active == null) {
            return;
        }
        JTextComponent c = active.get();
        if (c == null || c.getCaret() == null) {
            return;
        }
        int offset = c.getCaret().getDot();
        DataObject d = this.peerDO;
        if (d == null) {
            return;
        }
        WeakHashMap weakHashMap = this.uiCache;
        synchronized (weakHashMap) {
            Reference cache = (Reference)this.uiCache.get(d);
            if (cache == null || (panel = (NavigatorContentPanel)cache.get()) == null) {
                return;
            }
        }
        panel.selectTreeNode(offset);
    }

    private JTextComponent findActivePane() {
        DataObject d = this.peerDO;
        LOG.fine(this + ": findActivePane DataObject=" + d);
        if (d == null) {
            return null;
        }
        EditorCookie ec = (EditorCookie)d.getCookie(EditorCookie.class);
        if (ec == null) {
            return null;
        }
        JTextComponent focused = EditorRegistry.focusedComponent();
        LOG.fine(this + ": findActivePane focused=" + focused);
        if (focused == null) {
            return null;
        }
        JEditorPane[] comps = ec.getOpenedPanes();
        if (comps == null) {
            return null;
        }
        for (JEditorPane c : comps) {
            if (c != focused) continue;
            return c;
        }
        return null;
    }

    private void attachEditorObservableListener(DataObject d) {
        EditorCookie.Observable obs = (EditorCookie.Observable)d.getCookie(EditorCookie.Observable.class);
        if (obs == null) {
            ErrorManager.getDefault().log(1, "The DataObject " + d.getName() + "(class=" + d.getClass().getName() + ") has no EditorCookie.Observable!");
        } else {
            this.peerWL = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)obs);
            obs.addPropertyChangeListener(this.peerWL);
        }
    }

    @Override
    public void navigate(final DataObject d) {
        this.attachDataObject(d);
        final EditorCookie ec = (EditorCookie)d.getCookie(EditorCookie.class);
        if (ec == null) {
            ErrorManager.getDefault().log(1, "The DataObject " + d.getName() + "(class=" + d.getClass().getName() + ") has no EditorCookie!?");
        } else {
            RP.post(new Runnable(){
                final /* synthetic */ NavigatorContent this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    try {
                        BaseDocument bdoc = (BaseDocument)ec.openDocument();
                        if (bdoc != null) {
                            this.this$0.navigate(d, bdoc);
                        }
                    }
                    catch (UserQuestionException uqe) {
                        this.this$0.showError(AbstractXMLNavigatorContent.ERROR_TOO_LARGE_DOCUMENT);
                    }
                    catch (IOException e) {
                        ErrorManager.getDefault().notify((Throwable)e);
                    }
                }
            });
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        JComponent p;
        boolean result = super.requestFocusInWindow();
        if (this.getComponentCount() > 0 && (p = (JComponent)this.getComponent(0)) instanceof NavigatorContentPanel) {
            ((NavigatorContentPanel)p).focus(true);
        }
        return result;
    }

    @Override
    public void requestFocus() {
        JComponent p;
        super.requestFocus();
        if (this.getComponentCount() > 0 && (p = (JComponent)this.getComponent(0)) instanceof NavigatorContentPanel) {
            ((NavigatorContentPanel)p).focus(false);
        }
    }

    @Override
    protected boolean isLoading() {
        return this.loading;
    }

    private void placeContentPanel(JPanel panel) {
        this.removeAll();
        this.add((Component)panel, "Center");
        this.revalidate();
        this.repaint();
        this.loading = false;
        this.updateActiveEditor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void navigate(final DataObject documentDO, BaseDocument bdoc) {
        NavigatorContentPanel cachedPanel;
        WeakHashMap weakHashMap = this.uiCache;
        synchronized (weakHashMap) {
            WeakReference panelWR = (WeakReference)this.uiCache.get(documentDO);
            if (panelWR != null) {
                NavigatorContentPanel cp = (NavigatorContentPanel)panelWR.get();
                if (cp != null) {
                    NavigatorContentPanel navigatorContentPanel = cachedPanel = bdoc == cp.getDocument() ? cp : null;
                    if (cachedPanel == null) {
                        this.uiCache.remove(documentDO);
                    }
                } else {
                    cachedPanel = null;
                }
            } else {
                cachedPanel = null;
            }
        }
        if (cachedPanel != null) {
            final NavigatorContentPanel cachedPanelFinal = cachedPanel;
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ NavigatorContent this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.placeContentPanel(cachedPanelFinal);
                }
            });
            return;
        }
        this.loading = true;
        this.showWaitPanel();
        try {
            final DocumentModel model = bdoc.getLength() != 0 ? DocumentModel.getDocumentModel((Document)bdoc) : null;
            if (model == null) {
                MimePath mp = MimePath.parse((String)DocumentUtilities.getMimeType((Document)bdoc));
                if (mp == null || "text/xml".equals(mp.getInheritedType())) {
                    this.showError(AbstractXMLNavigatorContent.ERROR_CANNOT_NAVIGATE);
                }
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ NavigatorContent this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    JPanel panel;
                    block7: {
                        panel = null;
                        if (cachedPanel == null) {
                            try {
                                model.readLock();
                                panel = this.this$0.new NavigatorContentPanel(model);
                                WeakHashMap weakHashMap = this.this$0.uiCache;
                                synchronized (weakHashMap) {
                                    this.this$0.uiCache.put(documentDO, new WeakReference<JPanel>(panel));
                                    break block7;
                                }
                            }
                            finally {
                                model.readUnlock();
                            }
                        }
                        panel = cachedPanel;
                    }
                    this.this$0.placeContentPanel(panel);
                }
            });
        }
        catch (DocumentModelException dme) {
            ErrorManager.getDefault().notify(1, (Throwable)dme);
        }
    }

    @Override
    public void release() {
        this.removeAll();
        this.repaint();
        this.attachDataObject(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attachDataObject(DataObject replaceObject) {
        NavigatorContent navigatorContent = this;
        synchronized (navigatorContent) {
            EditorCookie.Observable cake;
            DataObject dobj = this.peerDO;
            if (dobj == replaceObject) {
                return;
            }
            LOG.fine(this + ": Closing doucment " + dobj + ", replacing with " + replaceObject);
            this.peerDO = replaceObject;
            if (dobj != null && (cake = (EditorCookie.Observable)dobj.getCookie(EditorCookie.Observable.class)) != null) {
                cake.removePropertyChangeListener(this.peerWL);
            }
            this.peerWL = null;
            if (replaceObject != null) {
                this.attachEditorObservableListener(replaceObject);
            }
        }
    }

    @Override
    public String toString() {
        return "NavigatorContent[" + Integer.toHexString(System.identityHashCode(this)) + "]";
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        DataObject dobj;
        if (evt.getPropertyName() == "document" && evt.getNewValue() == null && (dobj = ((DataEditorSupport)evt.getSource()).getDataObject()) != null) {
            this.attachDataObject(null);
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ NavigatorContent this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    if (dobj.isValid()) {
                        this.this$0.navigate(dobj);
                    }
                }
            });
        }
        if ("focusGained".equals(evt.getPropertyName())) {
            SwingUtilities.invokeLater(this);
        }
    }

    private class NavigatorContentPanel
    extends JPanel
    implements FiltersManager.FilterChangeListener {
        private JTree tree;
        private FiltersManager filters;
        private Document doc;
        public static final String ATTRIBUTES_FILTER = "attrs";
        public static final String CONTENT_FILTER = "content";

        public NavigatorContentPanel(DocumentModel dm) {
            this.doc = dm.getDocument();
            this.setLayout(new BorderLayout());
            this.tree = new PatchedJTree();
            TreeModel model = this.createTreeModel(dm);
            this.tree.setModel(model);
            this.tree.setShowsRootHandles(true);
            this.tree.setRootVisible(false);
            this.tree.setCellRenderer(new NavigatorTreeCellRenderer());
            this.tree.putClientProperty("JTree.lineStyle", "Angled");
            ToolTipManager.sharedInstance().registerComponent(this.tree);
            MouseAdapter ml = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int selRow = NavigatorContentPanel.this.tree.getRowForLocation(e.getX(), e.getY());
                    if (selRow != -1) {
                        TreePath selPath = NavigatorContentPanel.this.tree.getPathForLocation(e.getX(), e.getY());
                        TreeNodeAdapter tna = (TreeNodeAdapter)selPath.getLastPathComponent();
                        if (e.getClickCount() == 2) {
                            NavigatorContentPanel.this.openAndFocusElement(tna, false);
                        }
                        if (e.getClickCount() == 1) {
                            NavigatorContentPanel.this.openAndFocusElement(tna, true);
                        }
                    }
                }
            };
            this.tree.addMouseListener(ml);
            final DefaultTreeSelectionModel selectionModel = new DefaultTreeSelectionModel();
            selectionModel.setSelectionMode(1);
            this.tree.setSelectionModel(selectionModel);
            this.tree.getInputMap().put(KeyStroke.getKeyStroke(10, 0), "open");
            this.tree.getActionMap().put("open", new AbstractAction(this){
                final /* synthetic */ NavigatorContentPanel this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreePath selPath = selectionModel.getLeadSelectionPath();
                    if (selPath != null) {
                        TreeNodeAdapter tna = (TreeNodeAdapter)selPath.getLastPathComponent();
                        this.this$1.openAndFocusElement(tna, false);
                    }
                }
            });
            JScrollPane treeView = new JScrollPane(this.tree);
            treeView.setBorder(BorderFactory.createEmptyBorder());
            treeView.setViewportBorder(BorderFactory.createEmptyBorder());
            this.add((Component)treeView, "Center");
            TapPanel filtersPanel = new TapPanel();
            JLabel filtersLbl = new JLabel(NbBundle.getMessage(NavigatorContent.class, (String)"LBL_Filter"));
            filtersLbl.setBorder(new EmptyBorder(0, 5, 5, 0));
            filtersPanel.add(filtersLbl);
            filtersPanel.setOrientation(2);
            KeyStroke toggleKey = KeyStroke.getKeyStroke(84, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
            String keyText = Utilities.keyToString((KeyStroke)toggleKey);
            filtersPanel.setToolTipText(NbBundle.getMessage(NavigatorContent.class, (String)"TIP_TapPanel", (Object)keyText));
            this.filters = this.createFilters();
            this.filters.hookChangeListener(this);
            filtersPanel.add(this.filters.getComponent());
            this.add((Component)filtersPanel, "South");
            MouseAdapter pmml = new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (e.getClickCount() == 1 && e.getModifiers() == 4) {
                        JPopupMenu pm = new JPopupMenu();
                        JMenuItem[] items = new FilterActions(NavigatorContentPanel.this.filters).createMenuItems();
                        for (int i = 0; i < items.length; ++i) {
                            pm.add(items[i]);
                        }
                        pm.pack();
                        pm.show(NavigatorContentPanel.this.tree, e.getX(), e.getY());
                    }
                }
            };
            this.tree.addMouseListener(pmml);
            TreeNode rootNode = (TreeNode)model.getRoot();
            for (int i = 0; i < rootNode.getChildCount(); ++i) {
                TreeNode node = rootNode.getChildAt(i);
                if (node.getChildCount() <= 0) continue;
                this.tree.expandPath(new TreePath(new TreeNode[]{rootNode, node}));
            }
        }

        public void selectTreeNode(int offset) {
            TreeNodeAdapter root = (TreeNodeAdapter)this.tree.getModel().getRoot();
            int from = root.getStart();
            int to = root.getEnd();
            if (offset < from || offset >= to) {
                return;
            }
            TreePath p = new TreePath(root);
            boolean cont = true;
            block0: while (cont) {
                cont = false;
                Enumeration chE = root.children();
                while (chE.hasMoreElements()) {
                    TreeNodeAdapter ch = (TreeNodeAdapter)chE.nextElement();
                    if (offset < ch.getStart()) break block0;
                    if (offset >= ch.getEnd()) continue;
                    root = ch;
                    p = p.pathByAddingChild(ch);
                    cont = true;
                    continue block0;
                }
            }
            this.tree.scrollPathToVisible(p);
            this.tree.setSelectionPath(p);
        }

        public Document getDocument() {
            return this.doc;
        }

        private void openAndFocusElement(final TreeNodeAdapter selected, final boolean selectLineOnly) {
            BaseDocument bdoc = (BaseDocument)selected.getDocumentElement().getDocument();
            DataObject dobj = NbEditorUtilities.getDataObject((Document)bdoc);
            if (dobj == null) {
                return;
            }
            final EditorCookie.Observable ec = (EditorCookie.Observable)dobj.getCookie(EditorCookie.Observable.class);
            if (ec == null) {
                return;
            }
            try {
                StyledDocument styledDocument = ec.openDocument();
            }
            catch (IOException ioe) {
                ErrorManager.getDefault().notify(1, (Throwable)ioe);
            }
            SwingUtilities.invokeLater(new Runnable(){
                final /* synthetic */ NavigatorContentPanel this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    JEditorPane[] panes = ec.getOpenedPanes();
                    if (panes != null && panes.length > 0) {
                        this.this$1.selectElementInPane(panes[0], selected, !selectLineOnly);
                    } else if (!selectLineOnly) {
                        ec.open();
                        panes = ec.getOpenedPanes();
                        if (panes != null && panes.length > 0) {
                            this.this$1.selectElementInPane(panes[0], selected, true);
                        }
                    }
                }
            });
        }

        private void selectElementInPane(final JEditorPane pane, final TreeNodeAdapter tna, boolean focus) {
            RP.post(new Runnable(){
                final /* synthetic */ NavigatorContentPanel this$1;
                {
                    this.this$1 = this$1;
                }

                @Override
                public void run() {
                    pane.setCaretPosition(tna.getDocumentElement().getStartOffset());
                }
            });
            if (focus) {
                Container temp = pane;
                while (!(temp instanceof TopComponent)) {
                    temp = temp.getParent();
                }
                ((TopComponent)temp).requestActive();
            }
        }

        private TreeModel createTreeModel(DocumentModel dm) {
            DocumentElement rootElement = dm.getRootElement();
            DefaultTreeModel dtm = new DefaultTreeModel(null);
            TreeNodeAdapter rootTna = new TreeNodeAdapter(rootElement, dtm, this.tree, null);
            dtm.setRoot(rootTna);
            return dtm;
        }

        private FiltersManager createFilters() {
            FiltersDescription desc = new FiltersDescription();
            desc.addFilter(ATTRIBUTES_FILTER, NbBundle.getMessage(NavigatorContent.class, (String)"LBL_ShowAttributes"), NbBundle.getMessage(NavigatorContent.class, (String)"LBL_ShowAttributesTip"), showAttributes, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/xml/text/navigator/resources/a.png", (boolean)false), null);
            desc.addFilter(CONTENT_FILTER, NbBundle.getMessage(NavigatorContent.class, (String)"LBL_ShowContent"), NbBundle.getMessage(NavigatorContent.class, (String)"LBL_ShowContentTip"), showContent, ImageUtilities.loadImageIcon((String)"org/netbeans/modules/xml/text/navigator/resources/content.png", (boolean)false), null);
            return FiltersDescription.createManager(desc);
        }

        @Override
        public void filterStateChanged(ChangeEvent e) {
            showAttributes = this.filters.isSelected(ATTRIBUTES_FILTER);
            showContent = this.filters.isSelected(CONTENT_FILTER);
            this.tree.repaint();
        }

        public void focus(boolean inWindow) {
            if (inWindow) {
                this.tree.requestFocusInWindow();
            } else {
                this.tree.requestFocus();
            }
        }

        private class PatchedJTree
        extends JTree {
            private boolean firstPaint = true;

            @Override
            public void paint(Graphics g) {
                if (this.firstPaint) {
                    int height = g.getFontMetrics(this.getFont()).getHeight();
                    this.setRowHeight(height + 2);
                    this.firstPaint = false;
                }
                super.paint(g);
            }
        }
    }
}

