/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.twig.editor.completion;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.ElementHandle;
import org.netbeans.modules.csl.api.ElementKind;
import org.netbeans.modules.csl.api.HtmlFormatter;
import org.netbeans.modules.csl.api.Modifier;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.twig.editor.completion.TwigDocumentation;
import org.netbeans.modules.php.twig.editor.completion.TwigDocumentationFactory;
import org.openide.filesystems.FileObject;

public interface TwigElement
extends ElementHandle {
    public String getTemplate();

    public void formatParameters(HtmlFormatter var1);

    public TwigDocumentation getDocumentation();

    public static class Parameter {
        private final String name;
        private final Need need;

        public Parameter(String name) {
            this(name, Need.MANDATORY);
        }

        public Parameter(String name, Need need) {
            this.name = name;
            this.need = need;
        }

        public void format(HtmlFormatter formatter) {
            if (!this.isMandatory()) {
                formatter.appendText(this.name);
            } else {
                formatter.emphasis(true);
                formatter.appendText(this.name);
                formatter.emphasis(false);
            }
        }

        public void prepareTemplate(StringBuilder template) {
            template.append("${").append(this.name).append("}");
        }

        private boolean isMandatory() {
            return Need.MANDATORY.equals((Object)this.need);
        }

        public static enum Need {
            OPTIONAL,
            MANDATORY;

        }
    }

    public static class TwigElementWithParams
    extends BaseTwigElementItem {
        private final List<Parameter> parameters;

        public TwigElementWithParams(String name, TwigDocumentationFactory documentationFactory, List<Parameter> parameters) {
            super(name, documentationFactory);
            this.parameters = parameters;
        }

        @Override
        public void formatParameters(HtmlFormatter formatter) {
            formatter.appendText("(");
            for (int i = 0; i < this.parameters.size(); ++i) {
                Parameter parameter = this.parameters.get(i);
                if (i != 0) {
                    formatter.appendText(", ");
                }
                parameter.format(formatter);
            }
            formatter.appendText(")");
        }

        @Override
        public String getTemplate() {
            StringBuilder template = new StringBuilder();
            template.append(this.getName());
            template.append("(");
            for (int i = 0; i < this.parameters.size(); ++i) {
                Parameter parameter = this.parameters.get(i);
                if (i != 0) {
                    template.append(", ");
                }
                parameter.prepareTemplate(template);
            }
            template.append(")");
            return template.toString();
        }
    }

    public static class TwigElementWithCustomTemplate
    extends BaseTwigElementItem {
        private final String customTemplate;

        public TwigElementWithCustomTemplate(String name, TwigDocumentationFactory documentationFactory, String customTemplate) {
            super(name, documentationFactory);
            this.customTemplate = customTemplate;
        }

        @Override
        public String getTemplate() {
            return this.customTemplate;
        }

        @Override
        public void formatParameters(HtmlFormatter formatter) {
        }
    }

    public static class TwigElementWithoutParams
    extends BaseTwigElementItem {
        public TwigElementWithoutParams(String name, TwigDocumentationFactory documentationFactory) {
            super(name, documentationFactory);
        }

        @Override
        public String getTemplate() {
            return this.getName();
        }

        @Override
        public void formatParameters(HtmlFormatter formatter) {
        }
    }

    public static abstract class BaseTwigElementItem
    implements TwigElement {
        private final String name;
        private final TwigDocumentationFactory documentationFactory;

        public BaseTwigElementItem(String name, TwigDocumentationFactory documentationFactory) {
            this.name = name;
            this.documentationFactory = documentationFactory;
        }

        public String getName() {
            return this.name;
        }

        public FileObject getFileObject() {
            return null;
        }

        public String getMimeType() {
            return "";
        }

        public String getIn() {
            return "";
        }

        public ElementKind getKind() {
            return ElementKind.OTHER;
        }

        public Set<Modifier> getModifiers() {
            return Collections.emptySet();
        }

        public boolean signatureEquals(ElementHandle handle) {
            return false;
        }

        public OffsetRange getOffsetRange(ParserResult result) {
            return OffsetRange.NONE;
        }

        @Override
        public TwigDocumentation getDocumentation() {
            return this.documentationFactory.create(this.getName());
        }
    }

    public static class Factory {
        public static TwigElement create(String name, TwigDocumentationFactory documentationFactory) {
            return new TwigElementWithoutParams(name, documentationFactory);
        }

        public static TwigElement create(String name, TwigDocumentationFactory documentationFactory, List<Parameter> parameters) {
            return new TwigElementWithParams(name, documentationFactory, parameters);
        }

        public static TwigElement create(String name, TwigDocumentationFactory documentationFactory, String customTemplate) {
            return new TwigElementWithCustomTemplate(name, documentationFactory, customTemplate);
        }
    }
}

