/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetServiceRequest
extends BmcRequest<Void> {
    private String serviceId;

    public String getServiceId() {
        return this.serviceId;
    }

    public Builder toBuilder() {
        return new Builder().serviceId(this.serviceId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",serviceId=").append(String.valueOf(this.serviceId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetServiceRequest)) {
            return false;
        }
        GetServiceRequest other = (GetServiceRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.serviceId, other.serviceId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.serviceId == null ? 43 : this.serviceId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetServiceRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String serviceId = null;

        public Builder serviceId(String serviceId) {
            this.serviceId = serviceId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetServiceRequest o) {
            this.serviceId(o.getServiceId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetServiceRequest build() {
            GetServiceRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetServiceRequest buildWithoutInvocationCallback() {
            GetServiceRequest request = new GetServiceRequest();
            request.serviceId = this.serviceId;
            return request;
        }
    }
}

