/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.config.xml.ds;

import org.netbeans.modules.javaee.wildfly.config.xml.AbstractHierarchicalHandler;
import org.netbeans.modules.javaee.wildfly.config.xml.ds.WildflyDriver;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class WildflyDriverHandler
extends AbstractHierarchicalHandler {
    private WildflyDriver driver;
    private StringBuilder buffer;

    public WildflyDriverHandler(DefaultHandler parent, XMLReader parser) {
        super(parent, parser);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if ("driver".equals(qName)) {
            this.driver = new WildflyDriver(attributes.getValue(uri, "name"));
        } else if ("xa-datasource-class".equals(qName) || "datasource-class".equals(qName) || "driver-class".equals(qName)) {
            this.buffer = new StringBuilder();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.buffer != null) {
            this.buffer.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if ("driver".equals(qName)) {
            this.end(uri, localName, qName);
        } else if ("driver-class".equals(qName)) {
            this.driver.setDriverClass(this.buffer.toString());
        } else if (("xa-datasource-class".equals(qName) || "datasource-class".equals(qName)) && null == this.driver.getDriverClass()) {
            this.driver.setDriverClass("");
        }
    }

    public WildflyDriver getDriver() {
        return this.driver;
    }
}

