/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.TargetAppRunner;
import org.netbeans.lib.profiler.client.MonitoredData;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.results.monitor.VMTelemetryDataManager;
import org.netbeans.lib.profiler.results.threads.ThreadsDataManager;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.api.ProfilerDialogs;

public final class ProfilingMonitor {
    static final String PROPERTY_SERVER_STATE = "serverState";
    static final String PROPERTY_SERVER_PROGRESS = "serverProgress";
    private UpdateThread monitorThread;
    private boolean updateThreadStarted = false;
    private int serverState = 0;
    private int serverProgress = -1;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    public ProfilingMonitor() {
        this.monitorThread = new UpdateThread();
    }

    public void monitorVM(TargetAppRunner runner) {
        this.setServerState(1);
        this.setServerProgress(-1);
        if (!this.updateThreadStarted) {
            this.updateThreadStarted = true;
            this.monitorThread.start();
        }
        this.monitorThread.monitor(runner);
    }

    public void stopDisplayingVM() {
        if (this.monitorThread != null) {
            this.monitorThread.monitor(null);
        }
    }

    public void stopUpdateThread() {
        if (this.monitorThread != null) {
            this.monitorThread.stopThread();
            this.monitorThread = null;
        }
    }

    private void setServerState(int serverState) {
        if (this.serverState != serverState) {
            int oldValue = this.serverState;
            this.serverState = serverState;
            this.propertyChangeSupport.firePropertyChange(PROPERTY_SERVER_STATE, oldValue, serverState);
        }
    }

    int getServerState() {
        return this.serverState;
    }

    private void setServerProgress(int serverProgress) {
        if (this.serverProgress != serverProgress) {
            int oldValue = this.serverProgress;
            this.serverProgress = serverProgress;
            this.propertyChangeSupport.firePropertyChange(PROPERTY_SERVER_PROGRESS, oldValue, serverProgress);
        }
    }

    int getServerProgress() {
        return this.serverProgress;
    }

    void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    final class UpdateThread
    extends Thread {
        private static final int UPDATE_INTERVAL = 1200;
        private TargetAppRunner runner;
        private ThreadsDataManager threadsDataManager;
        private VMTelemetryDataManager vmTelemetryManager;
        private boolean keepRunning;
        private volatile boolean oomeNotified;

        UpdateThread() {
            super("Profiler Monitor");
            this.keepRunning = true;
        }

        public void monitor(TargetAppRunner runner) {
            this.oomeNotified = false;
            this.runner = runner;
            this.threadsDataManager = Profiler.getDefault().getThreadsManager();
            this.vmTelemetryManager = Profiler.getDefault().getVMTelemetryManager();
            if (runner != null) {
                this.vmTelemetryManager.maxHeapSize = runner.getProfilingSessionStatus().maxHeapSize;
            }
        }

        @Override
        public void run() {
            while (this.keepRunning) {
                block8: {
                    try {
                        if (this.runner != null) {
                            final MonitoredData md = this.runner.getProfilerClient().getMonitoredData();
                            if (md != null) {
                                SwingUtilities.invokeAndWait(new Runnable(){
                                    final /* synthetic */ UpdateThread this$1;
                                    {
                                        this.this$1 = this$1;
                                    }

                                    @Override
                                    public void run() {
                                        block3: {
                                            try {
                                                this.this$1.ProfilingMonitor.this.setServerState(md.getServerState());
                                                this.this$1.ProfilingMonitor.this.setServerProgress(md.getServerProgress());
                                                this.this$1.threadsDataManager.processData(md);
                                                this.this$1.vmTelemetryManager.processData(md);
                                            }
                                            catch (Exception e) {
                                                Profiler.getDefault().notifyException(8, e);
                                            }
                                            catch (OutOfMemoryError e) {
                                                if (this.this$1.oomeNotified) break block3;
                                                this.this$1.oomeNotified = true;
                                                ProfilerDialogs.displayError((String)Bundle.ProfilingMonitor_OomeMsg());
                                            }
                                        }
                                    }
                                });
                            } else {
                                NetBeansProfiler.getDefaultNB().checkAndUpdateState();
                                this.runner = null;
                            }
                        }
                    }
                    catch (Throwable t) {
                        if (!(t instanceof ThreadDeath)) break block8;
                        throw (ThreadDeath)t;
                    }
                }
                try {
                    UpdateThread.sleep(1200L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }

        private void stopThread() {
            this.keepRunning = false;
        }
    }
}

